/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisvideoarchivedmedia.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.kinesisvideoarchivedmedia.KinesisVideoArchivedMediaClient;
import software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.GetImagesRequest;
import software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.GetImagesResponse;
import software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.Image;

public class GetImagesIterable
implements SdkIterable<GetImagesResponse> {
    private final KinesisVideoArchivedMediaClient client;
    private final GetImagesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetImagesIterable(KinesisVideoArchivedMediaClient client, GetImagesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetImagesResponseFetcher();
    }

    public Iterator<GetImagesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Image> images() {
        Function<GetImagesResponse, Iterator> getIterator = response -> {
            if (response != null && response.images() != null) {
                return response.images().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetImagesResponseFetcher
    implements SyncPageFetcher<GetImagesResponse> {
        private GetImagesResponseFetcher() {
        }

        public boolean hasNextPage(GetImagesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetImagesResponse nextPage(GetImagesResponse previousPage) {
            if (previousPage == null) {
                return GetImagesIterable.this.client.getImages(GetImagesIterable.this.firstRequest);
            }
            return GetImagesIterable.this.client.getImages((GetImagesRequest)((Object)GetImagesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

