/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An excerpt from a table within a document. The table excerpt displays up to five columns and three rows, depending on
 * how many table cells are relevant to the query and how many columns are available in the original table. The top most
 * relevant cell is displayed in the table excerpt, along with the next most relevant cells.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TableExcerpt implements SdkPojo, Serializable, ToCopyableBuilder<TableExcerpt.Builder, TableExcerpt> {
    private static final SdkField<List<TableRow>> ROWS_FIELD = SdkField
            .<List<TableRow>> builder(MarshallingType.LIST)
            .memberName("Rows")
            .getter(getter(TableExcerpt::rows))
            .setter(setter(Builder::rows))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rows").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TableRow> builder(MarshallingType.SDK_POJO)
                                            .constructor(TableRow::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> TOTAL_NUMBER_OF_ROWS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TotalNumberOfRows").getter(getter(TableExcerpt::totalNumberOfRows))
            .setter(setter(Builder::totalNumberOfRows))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalNumberOfRows").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROWS_FIELD,
            TOTAL_NUMBER_OF_ROWS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<TableRow> rows;

    private final Integer totalNumberOfRows;

    private TableExcerpt(BuilderImpl builder) {
        this.rows = builder.rows;
        this.totalNumberOfRows = builder.totalNumberOfRows;
    }

    /**
     * For responses, this returns true if the service returned a value for the Rows property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasRows() {
        return rows != null && !(rows instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of rows in the table excerpt.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRows} method.
     * </p>
     * 
     * @return A list of rows in the table excerpt.
     */
    public final List<TableRow> rows() {
        return rows;
    }

    /**
     * <p>
     * A count of the number of rows in the original table within the document.
     * </p>
     * 
     * @return A count of the number of rows in the original table within the document.
     */
    public final Integer totalNumberOfRows() {
        return totalNumberOfRows;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasRows() ? rows() : null);
        hashCode = 31 * hashCode + Objects.hashCode(totalNumberOfRows());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableExcerpt)) {
            return false;
        }
        TableExcerpt other = (TableExcerpt) obj;
        return hasRows() == other.hasRows() && Objects.equals(rows(), other.rows())
                && Objects.equals(totalNumberOfRows(), other.totalNumberOfRows());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TableExcerpt").add("Rows", hasRows() ? rows() : null)
                .add("TotalNumberOfRows", totalNumberOfRows()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Rows":
            return Optional.ofNullable(clazz.cast(rows()));
        case "TotalNumberOfRows":
            return Optional.ofNullable(clazz.cast(totalNumberOfRows()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TableExcerpt, T> g) {
        return obj -> g.apply((TableExcerpt) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TableExcerpt> {
        /**
         * <p>
         * A list of rows in the table excerpt.
         * </p>
         * 
         * @param rows
         *        A list of rows in the table excerpt.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rows(Collection<TableRow> rows);

        /**
         * <p>
         * A list of rows in the table excerpt.
         * </p>
         * 
         * @param rows
         *        A list of rows in the table excerpt.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rows(TableRow... rows);

        /**
         * <p>
         * A list of rows in the table excerpt.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.kendra.model.TableRow.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.kendra.model.TableRow#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.kendra.model.TableRow.Builder#build()} is called immediately and its
         * result is passed to {@link #rows(List<TableRow>)}.
         * 
         * @param rows
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.kendra.model.TableRow.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rows(java.util.Collection<TableRow>)
         */
        Builder rows(Consumer<TableRow.Builder>... rows);

        /**
         * <p>
         * A count of the number of rows in the original table within the document.
         * </p>
         * 
         * @param totalNumberOfRows
         *        A count of the number of rows in the original table within the document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalNumberOfRows(Integer totalNumberOfRows);
    }

    static final class BuilderImpl implements Builder {
        private List<TableRow> rows = DefaultSdkAutoConstructList.getInstance();

        private Integer totalNumberOfRows;

        private BuilderImpl() {
        }

        private BuilderImpl(TableExcerpt model) {
            rows(model.rows);
            totalNumberOfRows(model.totalNumberOfRows);
        }

        public final List<TableRow.Builder> getRows() {
            List<TableRow.Builder> result = TableRowListCopier.copyToBuilder(this.rows);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRows(Collection<TableRow.BuilderImpl> rows) {
            this.rows = TableRowListCopier.copyFromBuilder(rows);
        }

        @Override
        public final Builder rows(Collection<TableRow> rows) {
            this.rows = TableRowListCopier.copy(rows);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rows(TableRow... rows) {
            rows(Arrays.asList(rows));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rows(Consumer<TableRow.Builder>... rows) {
            rows(Stream.of(rows).map(c -> TableRow.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getTotalNumberOfRows() {
            return totalNumberOfRows;
        }

        public final void setTotalNumberOfRows(Integer totalNumberOfRows) {
            this.totalNumberOfRows = totalNumberOfRows;
        }

        @Override
        public final Builder totalNumberOfRows(Integer totalNumberOfRows) {
            this.totalNumberOfRows = totalNumberOfRows;
            return this;
        }

        @Override
        public TableExcerpt build() {
            return new TableExcerpt(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
