/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafkaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The description of a connector's provisioned capacity.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProvisionedCapacityDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<ProvisionedCapacityDescription.Builder, ProvisionedCapacityDescription> {
    private static final SdkField<Integer> MCU_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("mcuCount").getter(getter(ProvisionedCapacityDescription::mcuCount)).setter(setter(Builder::mcuCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mcuCount").build()).build();

    private static final SdkField<Integer> WORKER_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("workerCount").getter(getter(ProvisionedCapacityDescription::workerCount))
            .setter(setter(Builder::workerCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workerCount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MCU_COUNT_FIELD,
            WORKER_COUNT_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer mcuCount;

    private final Integer workerCount;

    private ProvisionedCapacityDescription(BuilderImpl builder) {
        this.mcuCount = builder.mcuCount;
        this.workerCount = builder.workerCount;
    }

    /**
     * <p>
     * The number of microcontroller units (MCUs) allocated to each connector worker. The valid values are 1,2,4,8.
     * </p>
     * 
     * @return The number of microcontroller units (MCUs) allocated to each connector worker. The valid values are
     *         1,2,4,8.
     */
    public final Integer mcuCount() {
        return mcuCount;
    }

    /**
     * <p>
     * The number of workers that are allocated to the connector.
     * </p>
     * 
     * @return The number of workers that are allocated to the connector.
     */
    public final Integer workerCount() {
        return workerCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(mcuCount());
        hashCode = 31 * hashCode + Objects.hashCode(workerCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProvisionedCapacityDescription)) {
            return false;
        }
        ProvisionedCapacityDescription other = (ProvisionedCapacityDescription) obj;
        return Objects.equals(mcuCount(), other.mcuCount()) && Objects.equals(workerCount(), other.workerCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProvisionedCapacityDescription").add("McuCount", mcuCount()).add("WorkerCount", workerCount())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "mcuCount":
            return Optional.ofNullable(clazz.cast(mcuCount()));
        case "workerCount":
            return Optional.ofNullable(clazz.cast(workerCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProvisionedCapacityDescription, T> g) {
        return obj -> g.apply((ProvisionedCapacityDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProvisionedCapacityDescription> {
        /**
         * <p>
         * The number of microcontroller units (MCUs) allocated to each connector worker. The valid values are 1,2,4,8.
         * </p>
         * 
         * @param mcuCount
         *        The number of microcontroller units (MCUs) allocated to each connector worker. The valid values are
         *        1,2,4,8.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mcuCount(Integer mcuCount);

        /**
         * <p>
         * The number of workers that are allocated to the connector.
         * </p>
         * 
         * @param workerCount
         *        The number of workers that are allocated to the connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workerCount(Integer workerCount);
    }

    static final class BuilderImpl implements Builder {
        private Integer mcuCount;

        private Integer workerCount;

        private BuilderImpl() {
        }

        private BuilderImpl(ProvisionedCapacityDescription model) {
            mcuCount(model.mcuCount);
            workerCount(model.workerCount);
        }

        public final Integer getMcuCount() {
            return mcuCount;
        }

        public final void setMcuCount(Integer mcuCount) {
            this.mcuCount = mcuCount;
        }

        @Override
        public final Builder mcuCount(Integer mcuCount) {
            this.mcuCount = mcuCount;
            return this;
        }

        public final Integer getWorkerCount() {
            return workerCount;
        }

        public final void setWorkerCount(Integer workerCount) {
            this.workerCount = workerCount;
        }

        @Override
        public final Builder workerCount(Integer workerCount) {
            this.workerCount = workerCount;
            return this;
        }

        @Override
        public ProvisionedCapacityDescription build() {
            return new ProvisionedCapacityDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
