/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafka.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateReplicationInfoResponse extends KafkaResponse implements
        ToCopyableBuilder<UpdateReplicationInfoResponse.Builder, UpdateReplicationInfoResponse> {
    private static final SdkField<String> REPLICATOR_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReplicatorArn").getter(getter(UpdateReplicationInfoResponse::replicatorArn))
            .setter(setter(Builder::replicatorArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicatorArn").build()).build();

    private static final SdkField<String> REPLICATOR_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReplicatorState").getter(getter(UpdateReplicationInfoResponse::replicatorStateAsString))
            .setter(setter(Builder::replicatorState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicatorState").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLICATOR_ARN_FIELD,
            REPLICATOR_STATE_FIELD));

    private final String replicatorArn;

    private final String replicatorState;

    private UpdateReplicationInfoResponse(BuilderImpl builder) {
        super(builder);
        this.replicatorArn = builder.replicatorArn;
        this.replicatorState = builder.replicatorState;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the replicator.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the replicator.
     */
    public final String replicatorArn() {
        return replicatorArn;
    }

    /**
     * <p>
     * State of the replicator.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #replicatorState}
     * will return {@link ReplicatorState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #replicatorStateAsString}.
     * </p>
     * 
     * @return State of the replicator.
     * @see ReplicatorState
     */
    public final ReplicatorState replicatorState() {
        return ReplicatorState.fromValue(replicatorState);
    }

    /**
     * <p>
     * State of the replicator.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #replicatorState}
     * will return {@link ReplicatorState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #replicatorStateAsString}.
     * </p>
     * 
     * @return State of the replicator.
     * @see ReplicatorState
     */
    public final String replicatorStateAsString() {
        return replicatorState;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(replicatorArn());
        hashCode = 31 * hashCode + Objects.hashCode(replicatorStateAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateReplicationInfoResponse)) {
            return false;
        }
        UpdateReplicationInfoResponse other = (UpdateReplicationInfoResponse) obj;
        return Objects.equals(replicatorArn(), other.replicatorArn())
                && Objects.equals(replicatorStateAsString(), other.replicatorStateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateReplicationInfoResponse").add("ReplicatorArn", replicatorArn())
                .add("ReplicatorState", replicatorStateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReplicatorArn":
            return Optional.ofNullable(clazz.cast(replicatorArn()));
        case "ReplicatorState":
            return Optional.ofNullable(clazz.cast(replicatorStateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateReplicationInfoResponse, T> g) {
        return obj -> g.apply((UpdateReplicationInfoResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KafkaResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateReplicationInfoResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the replicator.
         * </p>
         * 
         * @param replicatorArn
         *        The Amazon Resource Name (ARN) of the replicator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicatorArn(String replicatorArn);

        /**
         * <p>
         * State of the replicator.
         * </p>
         * 
         * @param replicatorState
         *        State of the replicator.
         * @see ReplicatorState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReplicatorState
         */
        Builder replicatorState(String replicatorState);

        /**
         * <p>
         * State of the replicator.
         * </p>
         * 
         * @param replicatorState
         *        State of the replicator.
         * @see ReplicatorState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReplicatorState
         */
        Builder replicatorState(ReplicatorState replicatorState);
    }

    static final class BuilderImpl extends KafkaResponse.BuilderImpl implements Builder {
        private String replicatorArn;

        private String replicatorState;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateReplicationInfoResponse model) {
            super(model);
            replicatorArn(model.replicatorArn);
            replicatorState(model.replicatorState);
        }

        public final String getReplicatorArn() {
            return replicatorArn;
        }

        public final void setReplicatorArn(String replicatorArn) {
            this.replicatorArn = replicatorArn;
        }

        @Override
        public final Builder replicatorArn(String replicatorArn) {
            this.replicatorArn = replicatorArn;
            return this;
        }

        public final String getReplicatorState() {
            return replicatorState;
        }

        public final void setReplicatorState(String replicatorState) {
            this.replicatorState = replicatorState;
        }

        @Override
        public final Builder replicatorState(String replicatorState) {
            this.replicatorState = replicatorState;
            return this;
        }

        @Override
        public final Builder replicatorState(ReplicatorState replicatorState) {
            this.replicatorState(replicatorState == null ? null : replicatorState.toString());
            return this;
        }

        @Override
        public UpdateReplicationInfoResponse build() {
            return new UpdateReplicationInfoResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
