/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivsrealtime.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ivsrealtime.IvsRealTimeClient;
import software.amazon.awssdk.services.ivsrealtime.internal.UserAgentUtils;
import software.amazon.awssdk.services.ivsrealtime.model.ListStageSessionsRequest;
import software.amazon.awssdk.services.ivsrealtime.model.ListStageSessionsResponse;

public class ListStageSessionsIterable
implements SdkIterable<ListStageSessionsResponse> {
    private final IvsRealTimeClient client;
    private final ListStageSessionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListStageSessionsIterable(IvsRealTimeClient client, ListStageSessionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListStageSessionsResponseFetcher();
    }

    public Iterator<ListStageSessionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListStageSessionsResponseFetcher
    implements SyncPageFetcher<ListStageSessionsResponse> {
        private ListStageSessionsResponseFetcher() {
        }

        public boolean hasNextPage(ListStageSessionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListStageSessionsResponse nextPage(ListStageSessionsResponse previousPage) {
            if (previousPage == null) {
                return ListStageSessionsIterable.this.client.listStageSessions(ListStageSessionsIterable.this.firstRequest);
            }
            return ListStageSessionsIterable.this.client.listStageSessions((ListStageSessionsRequest)((Object)ListStageSessionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

