/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivschat;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.ivschat.DefaultIvschatClientBuilder;
import software.amazon.awssdk.services.ivschat.IvschatClientBuilder;
import software.amazon.awssdk.services.ivschat.model.AccessDeniedException;
import software.amazon.awssdk.services.ivschat.model.ConflictException;
import software.amazon.awssdk.services.ivschat.model.CreateChatTokenRequest;
import software.amazon.awssdk.services.ivschat.model.CreateChatTokenResponse;
import software.amazon.awssdk.services.ivschat.model.CreateRoomRequest;
import software.amazon.awssdk.services.ivschat.model.CreateRoomResponse;
import software.amazon.awssdk.services.ivschat.model.DeleteMessageRequest;
import software.amazon.awssdk.services.ivschat.model.DeleteMessageResponse;
import software.amazon.awssdk.services.ivschat.model.DeleteRoomRequest;
import software.amazon.awssdk.services.ivschat.model.DeleteRoomResponse;
import software.amazon.awssdk.services.ivschat.model.DisconnectUserRequest;
import software.amazon.awssdk.services.ivschat.model.DisconnectUserResponse;
import software.amazon.awssdk.services.ivschat.model.GetRoomRequest;
import software.amazon.awssdk.services.ivschat.model.GetRoomResponse;
import software.amazon.awssdk.services.ivschat.model.InternalServerException;
import software.amazon.awssdk.services.ivschat.model.IvschatException;
import software.amazon.awssdk.services.ivschat.model.ListRoomsRequest;
import software.amazon.awssdk.services.ivschat.model.ListRoomsResponse;
import software.amazon.awssdk.services.ivschat.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.ivschat.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.ivschat.model.PendingVerificationException;
import software.amazon.awssdk.services.ivschat.model.ResourceNotFoundException;
import software.amazon.awssdk.services.ivschat.model.SendEventRequest;
import software.amazon.awssdk.services.ivschat.model.SendEventResponse;
import software.amazon.awssdk.services.ivschat.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.ivschat.model.TagResourceRequest;
import software.amazon.awssdk.services.ivschat.model.TagResourceResponse;
import software.amazon.awssdk.services.ivschat.model.ThrottlingException;
import software.amazon.awssdk.services.ivschat.model.UntagResourceRequest;
import software.amazon.awssdk.services.ivschat.model.UntagResourceResponse;
import software.amazon.awssdk.services.ivschat.model.UpdateRoomRequest;
import software.amazon.awssdk.services.ivschat.model.UpdateRoomResponse;
import software.amazon.awssdk.services.ivschat.model.ValidationException;
import software.amazon.awssdk.services.ivschat.paginators.ListRoomsIterable;

@SdkPublicApi
@ThreadSafe
public interface IvschatClient
extends SdkClient {
    public static final String SERVICE_NAME = "ivschat";
    public static final String SERVICE_METADATA_ID = "ivschat";

    public static IvschatClient create() {
        return (IvschatClient)IvschatClient.builder().build();
    }

    public static IvschatClientBuilder builder() {
        return new DefaultIvschatClientBuilder();
    }

    default public CreateChatTokenResponse createChatToken(CreateChatTokenRequest createChatTokenRequest) throws AccessDeniedException, ResourceNotFoundException, PendingVerificationException, ValidationException, AwsServiceException, SdkClientException, IvschatException {
        throw new UnsupportedOperationException();
    }

    default public CreateChatTokenResponse createChatToken(Consumer<CreateChatTokenRequest.Builder> createChatTokenRequest) throws AccessDeniedException, ResourceNotFoundException, PendingVerificationException, ValidationException, AwsServiceException, SdkClientException, IvschatException {
        return this.createChatToken((CreateChatTokenRequest)((Object)((CreateChatTokenRequest.Builder)CreateChatTokenRequest.builder().applyMutation(createChatTokenRequest)).build()));
    }

    default public CreateRoomResponse createRoom(CreateRoomRequest createRoomRequest) throws ConflictException, AccessDeniedException, ResourceNotFoundException, ServiceQuotaExceededException, PendingVerificationException, ValidationException, AwsServiceException, SdkClientException, IvschatException {
        throw new UnsupportedOperationException();
    }

    default public CreateRoomResponse createRoom(Consumer<CreateRoomRequest.Builder> createRoomRequest) throws ConflictException, AccessDeniedException, ResourceNotFoundException, ServiceQuotaExceededException, PendingVerificationException, ValidationException, AwsServiceException, SdkClientException, IvschatException {
        return this.createRoom((CreateRoomRequest)((Object)((CreateRoomRequest.Builder)CreateRoomRequest.builder().applyMutation(createRoomRequest)).build()));
    }

    default public DeleteMessageResponse deleteMessage(DeleteMessageRequest deleteMessageRequest) throws ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, IvschatException {
        throw new UnsupportedOperationException();
    }

    default public DeleteMessageResponse deleteMessage(Consumer<DeleteMessageRequest.Builder> deleteMessageRequest) throws ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, IvschatException {
        return this.deleteMessage((DeleteMessageRequest)((Object)((DeleteMessageRequest.Builder)DeleteMessageRequest.builder().applyMutation(deleteMessageRequest)).build()));
    }

    default public DeleteRoomResponse deleteRoom(DeleteRoomRequest deleteRoomRequest) throws AccessDeniedException, ResourceNotFoundException, PendingVerificationException, ValidationException, AwsServiceException, SdkClientException, IvschatException {
        throw new UnsupportedOperationException();
    }

    default public DeleteRoomResponse deleteRoom(Consumer<DeleteRoomRequest.Builder> deleteRoomRequest) throws AccessDeniedException, ResourceNotFoundException, PendingVerificationException, ValidationException, AwsServiceException, SdkClientException, IvschatException {
        return this.deleteRoom((DeleteRoomRequest)((Object)((DeleteRoomRequest.Builder)DeleteRoomRequest.builder().applyMutation(deleteRoomRequest)).build()));
    }

    default public DisconnectUserResponse disconnectUser(DisconnectUserRequest disconnectUserRequest) throws ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, IvschatException {
        throw new UnsupportedOperationException();
    }

    default public DisconnectUserResponse disconnectUser(Consumer<DisconnectUserRequest.Builder> disconnectUserRequest) throws ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, IvschatException {
        return this.disconnectUser((DisconnectUserRequest)((Object)((DisconnectUserRequest.Builder)DisconnectUserRequest.builder().applyMutation(disconnectUserRequest)).build()));
    }

    default public GetRoomResponse getRoom(GetRoomRequest getRoomRequest) throws AccessDeniedException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, IvschatException {
        throw new UnsupportedOperationException();
    }

    default public GetRoomResponse getRoom(Consumer<GetRoomRequest.Builder> getRoomRequest) throws AccessDeniedException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, IvschatException {
        return this.getRoom((GetRoomRequest)((Object)((GetRoomRequest.Builder)GetRoomRequest.builder().applyMutation(getRoomRequest)).build()));
    }

    default public ListRoomsResponse listRooms(ListRoomsRequest listRoomsRequest) throws AccessDeniedException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, IvschatException {
        throw new UnsupportedOperationException();
    }

    default public ListRoomsResponse listRooms(Consumer<ListRoomsRequest.Builder> listRoomsRequest) throws AccessDeniedException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, IvschatException {
        return this.listRooms((ListRoomsRequest)((Object)((ListRoomsRequest.Builder)ListRoomsRequest.builder().applyMutation(listRoomsRequest)).build()));
    }

    default public ListRoomsIterable listRoomsPaginator(ListRoomsRequest listRoomsRequest) throws AccessDeniedException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, IvschatException {
        throw new UnsupportedOperationException();
    }

    default public ListRoomsIterable listRoomsPaginator(Consumer<ListRoomsRequest.Builder> listRoomsRequest) throws AccessDeniedException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, IvschatException {
        return this.listRoomsPaginator((ListRoomsRequest)((Object)((ListRoomsRequest.Builder)ListRoomsRequest.builder().applyMutation(listRoomsRequest)).build()));
    }

    default public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws ResourceNotFoundException, InternalServerException, ValidationException, AwsServiceException, SdkClientException, IvschatException {
        throw new UnsupportedOperationException();
    }

    default public ListTagsForResourceResponse listTagsForResource(Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ResourceNotFoundException, InternalServerException, ValidationException, AwsServiceException, SdkClientException, IvschatException {
        return this.listTagsForResource((ListTagsForResourceRequest)((Object)((ListTagsForResourceRequest.Builder)ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest)).build()));
    }

    default public SendEventResponse sendEvent(SendEventRequest sendEventRequest) throws ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, IvschatException {
        throw new UnsupportedOperationException();
    }

    default public SendEventResponse sendEvent(Consumer<SendEventRequest.Builder> sendEventRequest) throws ThrottlingException, AccessDeniedException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, IvschatException {
        return this.sendEvent((SendEventRequest)((Object)((SendEventRequest.Builder)SendEventRequest.builder().applyMutation(sendEventRequest)).build()));
    }

    default public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ResourceNotFoundException, InternalServerException, ValidationException, AwsServiceException, SdkClientException, IvschatException {
        throw new UnsupportedOperationException();
    }

    default public TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) throws ResourceNotFoundException, InternalServerException, ValidationException, AwsServiceException, SdkClientException, IvschatException {
        return this.tagResource((TagResourceRequest)((Object)((TagResourceRequest.Builder)TagResourceRequest.builder().applyMutation(tagResourceRequest)).build()));
    }

    default public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ResourceNotFoundException, InternalServerException, ValidationException, AwsServiceException, SdkClientException, IvschatException {
        throw new UnsupportedOperationException();
    }

    default public UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) throws ResourceNotFoundException, InternalServerException, ValidationException, AwsServiceException, SdkClientException, IvschatException {
        return this.untagResource((UntagResourceRequest)((Object)((UntagResourceRequest.Builder)UntagResourceRequest.builder().applyMutation(untagResourceRequest)).build()));
    }

    default public UpdateRoomResponse updateRoom(UpdateRoomRequest updateRoomRequest) throws AccessDeniedException, ResourceNotFoundException, PendingVerificationException, ValidationException, AwsServiceException, SdkClientException, IvschatException {
        throw new UnsupportedOperationException();
    }

    default public UpdateRoomResponse updateRoom(Consumer<UpdateRoomRequest.Builder> updateRoomRequest) throws AccessDeniedException, ResourceNotFoundException, PendingVerificationException, ValidationException, AwsServiceException, SdkClientException, IvschatException {
        return this.updateRoom((UpdateRoomRequest)((Object)((UpdateRoomRequest.Builder)UpdateRoomRequest.builder().applyMutation(updateRoomRequest)).build()));
    }

    public static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of((String)"ivschat");
    }
}

