/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ivs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Object specifying the stream attribute on which to filter.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StreamFilters implements SdkPojo, Serializable, ToCopyableBuilder<StreamFilters.Builder, StreamFilters> {
    private static final SdkField<String> HEALTH_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("health")
            .getter(getter(StreamFilters::healthAsString)).setter(setter(Builder::health))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("health").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HEALTH_FIELD));

    private static final long serialVersionUID = 1L;

    private final String health;

    private StreamFilters(BuilderImpl builder) {
        this.health = builder.health;
    }

    /**
     * <p>
     * The stream’s health.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #health} will
     * return {@link StreamHealth#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #healthAsString}.
     * </p>
     * 
     * @return The stream’s health.
     * @see StreamHealth
     */
    public final StreamHealth health() {
        return StreamHealth.fromValue(health);
    }

    /**
     * <p>
     * The stream’s health.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #health} will
     * return {@link StreamHealth#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #healthAsString}.
     * </p>
     * 
     * @return The stream’s health.
     * @see StreamHealth
     */
    public final String healthAsString() {
        return health;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(healthAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamFilters)) {
            return false;
        }
        StreamFilters other = (StreamFilters) obj;
        return Objects.equals(healthAsString(), other.healthAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StreamFilters").add("Health", healthAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "health":
            return Optional.ofNullable(clazz.cast(healthAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StreamFilters, T> g) {
        return obj -> g.apply((StreamFilters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StreamFilters> {
        /**
         * <p>
         * The stream’s health.
         * </p>
         * 
         * @param health
         *        The stream’s health.
         * @see StreamHealth
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StreamHealth
         */
        Builder health(String health);

        /**
         * <p>
         * The stream’s health.
         * </p>
         * 
         * @param health
         *        The stream’s health.
         * @see StreamHealth
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StreamHealth
         */
        Builder health(StreamHealth health);
    }

    static final class BuilderImpl implements Builder {
        private String health;

        private BuilderImpl() {
        }

        private BuilderImpl(StreamFilters model) {
            health(model.health);
        }

        public final String getHealth() {
            return health;
        }

        public final void setHealth(String health) {
            this.health = health;
        }

        @Override
        public final Builder health(String health) {
            this.health = health;
            return this;
        }

        @Override
        public final Builder health(StreamHealth health) {
            this.health(health == null ? null : health.toString());
            return this;
        }

        @Override
        public StreamFilters build() {
            return new StreamFilters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
