/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotthingsgraph.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum FlowExecutionEventType {
    EXECUTION_STARTED("EXECUTION_STARTED"),
    EXECUTION_FAILED("EXECUTION_FAILED"),
    EXECUTION_ABORTED("EXECUTION_ABORTED"),
    EXECUTION_SUCCEEDED("EXECUTION_SUCCEEDED"),
    STEP_STARTED("STEP_STARTED"),
    STEP_FAILED("STEP_FAILED"),
    STEP_SUCCEEDED("STEP_SUCCEEDED"),
    ACTIVITY_SCHEDULED("ACTIVITY_SCHEDULED"),
    ACTIVITY_STARTED("ACTIVITY_STARTED"),
    ACTIVITY_FAILED("ACTIVITY_FAILED"),
    ACTIVITY_SUCCEEDED("ACTIVITY_SUCCEEDED"),
    START_FLOW_EXECUTION_TASK("START_FLOW_EXECUTION_TASK"),
    SCHEDULE_NEXT_READY_STEPS_TASK("SCHEDULE_NEXT_READY_STEPS_TASK"),
    THING_ACTION_TASK("THING_ACTION_TASK"),
    THING_ACTION_TASK_FAILED("THING_ACTION_TASK_FAILED"),
    THING_ACTION_TASK_SUCCEEDED("THING_ACTION_TASK_SUCCEEDED"),
    ACKNOWLEDGE_TASK_MESSAGE("ACKNOWLEDGE_TASK_MESSAGE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, FlowExecutionEventType> VALUE_MAP;
    private final String value;

    private FlowExecutionEventType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static FlowExecutionEventType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<FlowExecutionEventType> knownValues() {
        EnumSet<FlowExecutionEventType> knownValues = EnumSet.allOf(FlowExecutionEventType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(FlowExecutionEventType.class, FlowExecutionEventType::toString);
    }
}

