/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribePortalResponse extends IoTSiteWiseResponse implements
        ToCopyableBuilder<DescribePortalResponse.Builder, DescribePortalResponse> {
    private static final SdkField<String> PORTAL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("portalId").getter(getter(DescribePortalResponse::portalId)).setter(setter(Builder::portalId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portalId").build()).build();

    private static final SdkField<String> PORTAL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("portalArn").getter(getter(DescribePortalResponse::portalArn)).setter(setter(Builder::portalArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portalArn").build()).build();

    private static final SdkField<String> PORTAL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("portalName").getter(getter(DescribePortalResponse::portalName)).setter(setter(Builder::portalName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portalName").build()).build();

    private static final SdkField<String> PORTAL_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("portalDescription").getter(getter(DescribePortalResponse::portalDescription))
            .setter(setter(Builder::portalDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portalDescription").build()).build();

    private static final SdkField<String> PORTAL_CLIENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("portalClientId").getter(getter(DescribePortalResponse::portalClientId))
            .setter(setter(Builder::portalClientId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portalClientId").build()).build();

    private static final SdkField<String> PORTAL_START_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("portalStartUrl").getter(getter(DescribePortalResponse::portalStartUrl))
            .setter(setter(Builder::portalStartUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portalStartUrl").build()).build();

    private static final SdkField<String> PORTAL_CONTACT_EMAIL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("portalContactEmail").getter(getter(DescribePortalResponse::portalContactEmail))
            .setter(setter(Builder::portalContactEmail))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portalContactEmail").build())
            .build();

    private static final SdkField<PortalStatus> PORTAL_STATUS_FIELD = SdkField.<PortalStatus> builder(MarshallingType.SDK_POJO)
            .memberName("portalStatus").getter(getter(DescribePortalResponse::portalStatus))
            .setter(setter(Builder::portalStatus)).constructor(PortalStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portalStatus").build()).build();

    private static final SdkField<Instant> PORTAL_CREATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("portalCreationDate").getter(getter(DescribePortalResponse::portalCreationDate))
            .setter(setter(Builder::portalCreationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portalCreationDate").build())
            .build();

    private static final SdkField<Instant> PORTAL_LAST_UPDATE_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("portalLastUpdateDate").getter(getter(DescribePortalResponse::portalLastUpdateDate))
            .setter(setter(Builder::portalLastUpdateDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portalLastUpdateDate").build())
            .build();

    private static final SdkField<ImageLocation> PORTAL_LOGO_IMAGE_LOCATION_FIELD = SdkField
            .<ImageLocation> builder(MarshallingType.SDK_POJO).memberName("portalLogoImageLocation")
            .getter(getter(DescribePortalResponse::portalLogoImageLocation)).setter(setter(Builder::portalLogoImageLocation))
            .constructor(ImageLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portalLogoImageLocation").build())
            .build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(DescribePortalResponse::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<String> PORTAL_AUTH_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("portalAuthMode").getter(getter(DescribePortalResponse::portalAuthModeAsString))
            .setter(setter(Builder::portalAuthMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portalAuthMode").build()).build();

    private static final SdkField<String> NOTIFICATION_SENDER_EMAIL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("notificationSenderEmail").getter(getter(DescribePortalResponse::notificationSenderEmail))
            .setter(setter(Builder::notificationSenderEmail))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notificationSenderEmail").build())
            .build();

    private static final SdkField<Alarms> ALARMS_FIELD = SdkField.<Alarms> builder(MarshallingType.SDK_POJO).memberName("alarms")
            .getter(getter(DescribePortalResponse::alarms)).setter(setter(Builder::alarms)).constructor(Alarms::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alarms").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PORTAL_ID_FIELD,
            PORTAL_ARN_FIELD, PORTAL_NAME_FIELD, PORTAL_DESCRIPTION_FIELD, PORTAL_CLIENT_ID_FIELD, PORTAL_START_URL_FIELD,
            PORTAL_CONTACT_EMAIL_FIELD, PORTAL_STATUS_FIELD, PORTAL_CREATION_DATE_FIELD, PORTAL_LAST_UPDATE_DATE_FIELD,
            PORTAL_LOGO_IMAGE_LOCATION_FIELD, ROLE_ARN_FIELD, PORTAL_AUTH_MODE_FIELD, NOTIFICATION_SENDER_EMAIL_FIELD,
            ALARMS_FIELD));

    private final String portalId;

    private final String portalArn;

    private final String portalName;

    private final String portalDescription;

    private final String portalClientId;

    private final String portalStartUrl;

    private final String portalContactEmail;

    private final PortalStatus portalStatus;

    private final Instant portalCreationDate;

    private final Instant portalLastUpdateDate;

    private final ImageLocation portalLogoImageLocation;

    private final String roleArn;

    private final String portalAuthMode;

    private final String notificationSenderEmail;

    private final Alarms alarms;

    private DescribePortalResponse(BuilderImpl builder) {
        super(builder);
        this.portalId = builder.portalId;
        this.portalArn = builder.portalArn;
        this.portalName = builder.portalName;
        this.portalDescription = builder.portalDescription;
        this.portalClientId = builder.portalClientId;
        this.portalStartUrl = builder.portalStartUrl;
        this.portalContactEmail = builder.portalContactEmail;
        this.portalStatus = builder.portalStatus;
        this.portalCreationDate = builder.portalCreationDate;
        this.portalLastUpdateDate = builder.portalLastUpdateDate;
        this.portalLogoImageLocation = builder.portalLogoImageLocation;
        this.roleArn = builder.roleArn;
        this.portalAuthMode = builder.portalAuthMode;
        this.notificationSenderEmail = builder.notificationSenderEmail;
        this.alarms = builder.alarms;
    }

    /**
     * <p>
     * The ID of the portal.
     * </p>
     * 
     * @return The ID of the portal.
     */
    public final String portalId() {
        return portalId;
    }

    /**
     * <p>
     * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the portal,
     * which has the following format.
     * </p>
     * <p>
     * <code>arn:${Partition}:iotsitewise:${Region}:${Account}:portal/${PortalId}</code>
     * </p>
     * 
     * @return The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the
     *         portal, which has the following format.</p>
     *         <p>
     *         <code>arn:${Partition}:iotsitewise:${Region}:${Account}:portal/${PortalId}</code>
     */
    public final String portalArn() {
        return portalArn;
    }

    /**
     * <p>
     * The name of the portal.
     * </p>
     * 
     * @return The name of the portal.
     */
    public final String portalName() {
        return portalName;
    }

    /**
     * <p>
     * The portal's description.
     * </p>
     * 
     * @return The portal's description.
     */
    public final String portalDescription() {
        return portalDescription;
    }

    /**
     * <p>
     * The IAM Identity Center application generated client ID (used with IAM Identity Center APIs). IoT SiteWise
     * includes <code>portalClientId</code> for only portals that use IAM Identity Center to authenticate users.
     * </p>
     * 
     * @return The IAM Identity Center application generated client ID (used with IAM Identity Center APIs). IoT
     *         SiteWise includes <code>portalClientId</code> for only portals that use IAM Identity Center to
     *         authenticate users.
     */
    public final String portalClientId() {
        return portalClientId;
    }

    /**
     * <p>
     * The URL for the IoT SiteWise Monitor portal. You can use this URL to access portals that use IAM Identity Center
     * for authentication. For portals that use IAM for authentication, you must use the IoT SiteWise console to get a
     * URL that you can use to access the portal.
     * </p>
     * 
     * @return The URL for the IoT SiteWise Monitor portal. You can use this URL to access portals that use IAM Identity
     *         Center for authentication. For portals that use IAM for authentication, you must use the IoT SiteWise
     *         console to get a URL that you can use to access the portal.
     */
    public final String portalStartUrl() {
        return portalStartUrl;
    }

    /**
     * <p>
     * The Amazon Web Services administrator's contact email address.
     * </p>
     * 
     * @return The Amazon Web Services administrator's contact email address.
     */
    public final String portalContactEmail() {
        return portalContactEmail;
    }

    /**
     * <p>
     * The current status of the portal, which contains a state and any error message.
     * </p>
     * 
     * @return The current status of the portal, which contains a state and any error message.
     */
    public final PortalStatus portalStatus() {
        return portalStatus;
    }

    /**
     * <p>
     * The date the portal was created, in Unix epoch time.
     * </p>
     * 
     * @return The date the portal was created, in Unix epoch time.
     */
    public final Instant portalCreationDate() {
        return portalCreationDate;
    }

    /**
     * <p>
     * The date the portal was last updated, in Unix epoch time.
     * </p>
     * 
     * @return The date the portal was last updated, in Unix epoch time.
     */
    public final Instant portalLastUpdateDate() {
        return portalLastUpdateDate;
    }

    /**
     * <p>
     * The portal's logo image, which is available at a URL.
     * </p>
     * 
     * @return The portal's logo image, which is available at a URL.
     */
    public final ImageLocation portalLogoImageLocation() {
        return portalLogoImageLocation;
    }

    /**
     * <p>
     * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the service
     * role that allows the portal's users to access your IoT SiteWise resources on your behalf. For more information,
     * see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-service-role.html">Using service
     * roles for IoT SiteWise Monitor</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * 
     * @return The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the
     *         service role that allows the portal's users to access your IoT SiteWise resources on your behalf. For
     *         more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-service-role.html">Using service
     *         roles for IoT SiteWise Monitor</a> in the <i>IoT SiteWise User Guide</i>.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The service to use to authenticate users to the portal.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #portalAuthMode}
     * will return {@link AuthMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #portalAuthModeAsString}.
     * </p>
     * 
     * @return The service to use to authenticate users to the portal.
     * @see AuthMode
     */
    public final AuthMode portalAuthMode() {
        return AuthMode.fromValue(portalAuthMode);
    }

    /**
     * <p>
     * The service to use to authenticate users to the portal.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #portalAuthMode}
     * will return {@link AuthMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #portalAuthModeAsString}.
     * </p>
     * 
     * @return The service to use to authenticate users to the portal.
     * @see AuthMode
     */
    public final String portalAuthModeAsString() {
        return portalAuthMode;
    }

    /**
     * <p>
     * The email address that sends alarm notifications.
     * </p>
     * 
     * @return The email address that sends alarm notifications.
     */
    public final String notificationSenderEmail() {
        return notificationSenderEmail;
    }

    /**
     * <p>
     * Contains the configuration information of an alarm created in an IoT SiteWise Monitor portal.
     * </p>
     * 
     * @return Contains the configuration information of an alarm created in an IoT SiteWise Monitor portal.
     */
    public final Alarms alarms() {
        return alarms;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(portalId());
        hashCode = 31 * hashCode + Objects.hashCode(portalArn());
        hashCode = 31 * hashCode + Objects.hashCode(portalName());
        hashCode = 31 * hashCode + Objects.hashCode(portalDescription());
        hashCode = 31 * hashCode + Objects.hashCode(portalClientId());
        hashCode = 31 * hashCode + Objects.hashCode(portalStartUrl());
        hashCode = 31 * hashCode + Objects.hashCode(portalContactEmail());
        hashCode = 31 * hashCode + Objects.hashCode(portalStatus());
        hashCode = 31 * hashCode + Objects.hashCode(portalCreationDate());
        hashCode = 31 * hashCode + Objects.hashCode(portalLastUpdateDate());
        hashCode = 31 * hashCode + Objects.hashCode(portalLogoImageLocation());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(portalAuthModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(notificationSenderEmail());
        hashCode = 31 * hashCode + Objects.hashCode(alarms());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePortalResponse)) {
            return false;
        }
        DescribePortalResponse other = (DescribePortalResponse) obj;
        return Objects.equals(portalId(), other.portalId()) && Objects.equals(portalArn(), other.portalArn())
                && Objects.equals(portalName(), other.portalName())
                && Objects.equals(portalDescription(), other.portalDescription())
                && Objects.equals(portalClientId(), other.portalClientId())
                && Objects.equals(portalStartUrl(), other.portalStartUrl())
                && Objects.equals(portalContactEmail(), other.portalContactEmail())
                && Objects.equals(portalStatus(), other.portalStatus())
                && Objects.equals(portalCreationDate(), other.portalCreationDate())
                && Objects.equals(portalLastUpdateDate(), other.portalLastUpdateDate())
                && Objects.equals(portalLogoImageLocation(), other.portalLogoImageLocation())
                && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(portalAuthModeAsString(), other.portalAuthModeAsString())
                && Objects.equals(notificationSenderEmail(), other.notificationSenderEmail())
                && Objects.equals(alarms(), other.alarms());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribePortalResponse").add("PortalId", portalId()).add("PortalArn", portalArn())
                .add("PortalName", portalName()).add("PortalDescription", portalDescription())
                .add("PortalClientId", portalClientId()).add("PortalStartUrl", portalStartUrl())
                .add("PortalContactEmail", portalContactEmail()).add("PortalStatus", portalStatus())
                .add("PortalCreationDate", portalCreationDate()).add("PortalLastUpdateDate", portalLastUpdateDate())
                .add("PortalLogoImageLocation", portalLogoImageLocation()).add("RoleArn", roleArn())
                .add("PortalAuthMode", portalAuthModeAsString()).add("NotificationSenderEmail", notificationSenderEmail())
                .add("Alarms", alarms()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "portalId":
            return Optional.ofNullable(clazz.cast(portalId()));
        case "portalArn":
            return Optional.ofNullable(clazz.cast(portalArn()));
        case "portalName":
            return Optional.ofNullable(clazz.cast(portalName()));
        case "portalDescription":
            return Optional.ofNullable(clazz.cast(portalDescription()));
        case "portalClientId":
            return Optional.ofNullable(clazz.cast(portalClientId()));
        case "portalStartUrl":
            return Optional.ofNullable(clazz.cast(portalStartUrl()));
        case "portalContactEmail":
            return Optional.ofNullable(clazz.cast(portalContactEmail()));
        case "portalStatus":
            return Optional.ofNullable(clazz.cast(portalStatus()));
        case "portalCreationDate":
            return Optional.ofNullable(clazz.cast(portalCreationDate()));
        case "portalLastUpdateDate":
            return Optional.ofNullable(clazz.cast(portalLastUpdateDate()));
        case "portalLogoImageLocation":
            return Optional.ofNullable(clazz.cast(portalLogoImageLocation()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "portalAuthMode":
            return Optional.ofNullable(clazz.cast(portalAuthModeAsString()));
        case "notificationSenderEmail":
            return Optional.ofNullable(clazz.cast(notificationSenderEmail()));
        case "alarms":
            return Optional.ofNullable(clazz.cast(alarms()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribePortalResponse, T> g) {
        return obj -> g.apply((DescribePortalResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTSiteWiseResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribePortalResponse> {
        /**
         * <p>
         * The ID of the portal.
         * </p>
         * 
         * @param portalId
         *        The ID of the portal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portalId(String portalId);

        /**
         * <p>
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the
         * portal, which has the following format.
         * </p>
         * <p>
         * <code>arn:${Partition}:iotsitewise:${Region}:${Account}:portal/${PortalId}</code>
         * </p>
         * 
         * @param portalArn
         *        The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of
         *        the portal, which has the following format.</p>
         *        <p>
         *        <code>arn:${Partition}:iotsitewise:${Region}:${Account}:portal/${PortalId}</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portalArn(String portalArn);

        /**
         * <p>
         * The name of the portal.
         * </p>
         * 
         * @param portalName
         *        The name of the portal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portalName(String portalName);

        /**
         * <p>
         * The portal's description.
         * </p>
         * 
         * @param portalDescription
         *        The portal's description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portalDescription(String portalDescription);

        /**
         * <p>
         * The IAM Identity Center application generated client ID (used with IAM Identity Center APIs). IoT SiteWise
         * includes <code>portalClientId</code> for only portals that use IAM Identity Center to authenticate users.
         * </p>
         * 
         * @param portalClientId
         *        The IAM Identity Center application generated client ID (used with IAM Identity Center APIs). IoT
         *        SiteWise includes <code>portalClientId</code> for only portals that use IAM Identity Center to
         *        authenticate users.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portalClientId(String portalClientId);

        /**
         * <p>
         * The URL for the IoT SiteWise Monitor portal. You can use this URL to access portals that use IAM Identity
         * Center for authentication. For portals that use IAM for authentication, you must use the IoT SiteWise console
         * to get a URL that you can use to access the portal.
         * </p>
         * 
         * @param portalStartUrl
         *        The URL for the IoT SiteWise Monitor portal. You can use this URL to access portals that use IAM
         *        Identity Center for authentication. For portals that use IAM for authentication, you must use the IoT
         *        SiteWise console to get a URL that you can use to access the portal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portalStartUrl(String portalStartUrl);

        /**
         * <p>
         * The Amazon Web Services administrator's contact email address.
         * </p>
         * 
         * @param portalContactEmail
         *        The Amazon Web Services administrator's contact email address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portalContactEmail(String portalContactEmail);

        /**
         * <p>
         * The current status of the portal, which contains a state and any error message.
         * </p>
         * 
         * @param portalStatus
         *        The current status of the portal, which contains a state and any error message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portalStatus(PortalStatus portalStatus);

        /**
         * <p>
         * The current status of the portal, which contains a state and any error message.
         * </p>
         * This is a convenience method that creates an instance of the {@link PortalStatus.Builder} avoiding the need
         * to create one manually via {@link PortalStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PortalStatus.Builder#build()} is called immediately and its
         * result is passed to {@link #portalStatus(PortalStatus)}.
         * 
         * @param portalStatus
         *        a consumer that will call methods on {@link PortalStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #portalStatus(PortalStatus)
         */
        default Builder portalStatus(Consumer<PortalStatus.Builder> portalStatus) {
            return portalStatus(PortalStatus.builder().applyMutation(portalStatus).build());
        }

        /**
         * <p>
         * The date the portal was created, in Unix epoch time.
         * </p>
         * 
         * @param portalCreationDate
         *        The date the portal was created, in Unix epoch time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portalCreationDate(Instant portalCreationDate);

        /**
         * <p>
         * The date the portal was last updated, in Unix epoch time.
         * </p>
         * 
         * @param portalLastUpdateDate
         *        The date the portal was last updated, in Unix epoch time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portalLastUpdateDate(Instant portalLastUpdateDate);

        /**
         * <p>
         * The portal's logo image, which is available at a URL.
         * </p>
         * 
         * @param portalLogoImageLocation
         *        The portal's logo image, which is available at a URL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portalLogoImageLocation(ImageLocation portalLogoImageLocation);

        /**
         * <p>
         * The portal's logo image, which is available at a URL.
         * </p>
         * This is a convenience method that creates an instance of the {@link ImageLocation.Builder} avoiding the need
         * to create one manually via {@link ImageLocation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ImageLocation.Builder#build()} is called immediately and its
         * result is passed to {@link #portalLogoImageLocation(ImageLocation)}.
         * 
         * @param portalLogoImageLocation
         *        a consumer that will call methods on {@link ImageLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #portalLogoImageLocation(ImageLocation)
         */
        default Builder portalLogoImageLocation(Consumer<ImageLocation.Builder> portalLogoImageLocation) {
            return portalLogoImageLocation(ImageLocation.builder().applyMutation(portalLogoImageLocation).build());
        }

        /**
         * <p>
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the
         * service role that allows the portal's users to access your IoT SiteWise resources on your behalf. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-service-role.html">Using service
         * roles for IoT SiteWise Monitor</a> in the <i>IoT SiteWise User Guide</i>.
         * </p>
         * 
         * @param roleArn
         *        The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of
         *        the service role that allows the portal's users to access your IoT SiteWise resources on your behalf.
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-service-role.html">Using
         *        service roles for IoT SiteWise Monitor</a> in the <i>IoT SiteWise User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The service to use to authenticate users to the portal.
         * </p>
         * 
         * @param portalAuthMode
         *        The service to use to authenticate users to the portal.
         * @see AuthMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthMode
         */
        Builder portalAuthMode(String portalAuthMode);

        /**
         * <p>
         * The service to use to authenticate users to the portal.
         * </p>
         * 
         * @param portalAuthMode
         *        The service to use to authenticate users to the portal.
         * @see AuthMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthMode
         */
        Builder portalAuthMode(AuthMode portalAuthMode);

        /**
         * <p>
         * The email address that sends alarm notifications.
         * </p>
         * 
         * @param notificationSenderEmail
         *        The email address that sends alarm notifications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationSenderEmail(String notificationSenderEmail);

        /**
         * <p>
         * Contains the configuration information of an alarm created in an IoT SiteWise Monitor portal.
         * </p>
         * 
         * @param alarms
         *        Contains the configuration information of an alarm created in an IoT SiteWise Monitor portal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarms(Alarms alarms);

        /**
         * <p>
         * Contains the configuration information of an alarm created in an IoT SiteWise Monitor portal.
         * </p>
         * This is a convenience method that creates an instance of the {@link Alarms.Builder} avoiding the need to
         * create one manually via {@link Alarms#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Alarms.Builder#build()} is called immediately and its result is
         * passed to {@link #alarms(Alarms)}.
         * 
         * @param alarms
         *        a consumer that will call methods on {@link Alarms.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #alarms(Alarms)
         */
        default Builder alarms(Consumer<Alarms.Builder> alarms) {
            return alarms(Alarms.builder().applyMutation(alarms).build());
        }
    }

    static final class BuilderImpl extends IoTSiteWiseResponse.BuilderImpl implements Builder {
        private String portalId;

        private String portalArn;

        private String portalName;

        private String portalDescription;

        private String portalClientId;

        private String portalStartUrl;

        private String portalContactEmail;

        private PortalStatus portalStatus;

        private Instant portalCreationDate;

        private Instant portalLastUpdateDate;

        private ImageLocation portalLogoImageLocation;

        private String roleArn;

        private String portalAuthMode;

        private String notificationSenderEmail;

        private Alarms alarms;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePortalResponse model) {
            super(model);
            portalId(model.portalId);
            portalArn(model.portalArn);
            portalName(model.portalName);
            portalDescription(model.portalDescription);
            portalClientId(model.portalClientId);
            portalStartUrl(model.portalStartUrl);
            portalContactEmail(model.portalContactEmail);
            portalStatus(model.portalStatus);
            portalCreationDate(model.portalCreationDate);
            portalLastUpdateDate(model.portalLastUpdateDate);
            portalLogoImageLocation(model.portalLogoImageLocation);
            roleArn(model.roleArn);
            portalAuthMode(model.portalAuthMode);
            notificationSenderEmail(model.notificationSenderEmail);
            alarms(model.alarms);
        }

        public final String getPortalId() {
            return portalId;
        }

        public final void setPortalId(String portalId) {
            this.portalId = portalId;
        }

        @Override
        public final Builder portalId(String portalId) {
            this.portalId = portalId;
            return this;
        }

        public final String getPortalArn() {
            return portalArn;
        }

        public final void setPortalArn(String portalArn) {
            this.portalArn = portalArn;
        }

        @Override
        public final Builder portalArn(String portalArn) {
            this.portalArn = portalArn;
            return this;
        }

        public final String getPortalName() {
            return portalName;
        }

        public final void setPortalName(String portalName) {
            this.portalName = portalName;
        }

        @Override
        public final Builder portalName(String portalName) {
            this.portalName = portalName;
            return this;
        }

        public final String getPortalDescription() {
            return portalDescription;
        }

        public final void setPortalDescription(String portalDescription) {
            this.portalDescription = portalDescription;
        }

        @Override
        public final Builder portalDescription(String portalDescription) {
            this.portalDescription = portalDescription;
            return this;
        }

        public final String getPortalClientId() {
            return portalClientId;
        }

        public final void setPortalClientId(String portalClientId) {
            this.portalClientId = portalClientId;
        }

        @Override
        public final Builder portalClientId(String portalClientId) {
            this.portalClientId = portalClientId;
            return this;
        }

        public final String getPortalStartUrl() {
            return portalStartUrl;
        }

        public final void setPortalStartUrl(String portalStartUrl) {
            this.portalStartUrl = portalStartUrl;
        }

        @Override
        public final Builder portalStartUrl(String portalStartUrl) {
            this.portalStartUrl = portalStartUrl;
            return this;
        }

        public final String getPortalContactEmail() {
            return portalContactEmail;
        }

        public final void setPortalContactEmail(String portalContactEmail) {
            this.portalContactEmail = portalContactEmail;
        }

        @Override
        public final Builder portalContactEmail(String portalContactEmail) {
            this.portalContactEmail = portalContactEmail;
            return this;
        }

        public final PortalStatus.Builder getPortalStatus() {
            return portalStatus != null ? portalStatus.toBuilder() : null;
        }

        public final void setPortalStatus(PortalStatus.BuilderImpl portalStatus) {
            this.portalStatus = portalStatus != null ? portalStatus.build() : null;
        }

        @Override
        public final Builder portalStatus(PortalStatus portalStatus) {
            this.portalStatus = portalStatus;
            return this;
        }

        public final Instant getPortalCreationDate() {
            return portalCreationDate;
        }

        public final void setPortalCreationDate(Instant portalCreationDate) {
            this.portalCreationDate = portalCreationDate;
        }

        @Override
        public final Builder portalCreationDate(Instant portalCreationDate) {
            this.portalCreationDate = portalCreationDate;
            return this;
        }

        public final Instant getPortalLastUpdateDate() {
            return portalLastUpdateDate;
        }

        public final void setPortalLastUpdateDate(Instant portalLastUpdateDate) {
            this.portalLastUpdateDate = portalLastUpdateDate;
        }

        @Override
        public final Builder portalLastUpdateDate(Instant portalLastUpdateDate) {
            this.portalLastUpdateDate = portalLastUpdateDate;
            return this;
        }

        public final ImageLocation.Builder getPortalLogoImageLocation() {
            return portalLogoImageLocation != null ? portalLogoImageLocation.toBuilder() : null;
        }

        public final void setPortalLogoImageLocation(ImageLocation.BuilderImpl portalLogoImageLocation) {
            this.portalLogoImageLocation = portalLogoImageLocation != null ? portalLogoImageLocation.build() : null;
        }

        @Override
        public final Builder portalLogoImageLocation(ImageLocation portalLogoImageLocation) {
            this.portalLogoImageLocation = portalLogoImageLocation;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getPortalAuthMode() {
            return portalAuthMode;
        }

        public final void setPortalAuthMode(String portalAuthMode) {
            this.portalAuthMode = portalAuthMode;
        }

        @Override
        public final Builder portalAuthMode(String portalAuthMode) {
            this.portalAuthMode = portalAuthMode;
            return this;
        }

        @Override
        public final Builder portalAuthMode(AuthMode portalAuthMode) {
            this.portalAuthMode(portalAuthMode == null ? null : portalAuthMode.toString());
            return this;
        }

        public final String getNotificationSenderEmail() {
            return notificationSenderEmail;
        }

        public final void setNotificationSenderEmail(String notificationSenderEmail) {
            this.notificationSenderEmail = notificationSenderEmail;
        }

        @Override
        public final Builder notificationSenderEmail(String notificationSenderEmail) {
            this.notificationSenderEmail = notificationSenderEmail;
            return this;
        }

        public final Alarms.Builder getAlarms() {
            return alarms != null ? alarms.toBuilder() : null;
        }

        public final void setAlarms(Alarms.BuilderImpl alarms) {
            this.alarms = alarms != null ? alarms.build() : null;
        }

        @Override
        public final Builder alarms(Alarms alarms) {
            this.alarms = alarms;
            return this;
        }

        @Override
        public DescribePortalResponse build() {
            return new DescribePortalResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
