/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotsitewise.IoTSiteWiseAsyncClient;
import software.amazon.awssdk.services.iotsitewise.internal.UserAgentUtils;
import software.amazon.awssdk.services.iotsitewise.model.JobSummary;
import software.amazon.awssdk.services.iotsitewise.model.ListBulkImportJobsRequest;
import software.amazon.awssdk.services.iotsitewise.model.ListBulkImportJobsResponse;

public class ListBulkImportJobsPublisher
implements SdkPublisher<ListBulkImportJobsResponse> {
    private final IoTSiteWiseAsyncClient client;
    private final ListBulkImportJobsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListBulkImportJobsPublisher(IoTSiteWiseAsyncClient client, ListBulkImportJobsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListBulkImportJobsPublisher(IoTSiteWiseAsyncClient client, ListBulkImportJobsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListBulkImportJobsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListBulkImportJobsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<JobSummary> jobSummaries() {
        Function<ListBulkImportJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.jobSummaries() != null) {
                return response.jobSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListBulkImportJobsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListBulkImportJobsResponseFetcher
    implements AsyncPageFetcher<ListBulkImportJobsResponse> {
        private ListBulkImportJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListBulkImportJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListBulkImportJobsResponse> nextPage(ListBulkImportJobsResponse previousPage) {
            if (previousPage == null) {
                return ListBulkImportJobsPublisher.this.client.listBulkImportJobs(ListBulkImportJobsPublisher.this.firstRequest);
            }
            return ListBulkImportJobsPublisher.this.client.listBulkImportJobs((ListBulkImportJobsRequest)((Object)ListBulkImportJobsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

