/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum StorageType {
    SITEWISE_DEFAULT_STORAGE("SITEWISE_DEFAULT_STORAGE"),
    MULTI_LAYER_STORAGE("MULTI_LAYER_STORAGE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, StorageType> VALUE_MAP;
    private final String value;

    private StorageType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static StorageType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<StorageType> knownValues() {
        EnumSet<StorageType> knownValues = EnumSet.allOf(StorageType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(StorageType.class, StorageType::toString);
    }
}

