/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotroborunner.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Supported coordinates for worker position.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PositionCoordinates implements SdkPojo, Serializable,
        ToCopyableBuilder<PositionCoordinates.Builder, PositionCoordinates> {
    private static final SdkField<CartesianCoordinates> CARTESIAN_COORDINATES_FIELD = SdkField
            .<CartesianCoordinates> builder(MarshallingType.SDK_POJO).memberName("cartesianCoordinates")
            .getter(getter(PositionCoordinates::cartesianCoordinates)).setter(setter(Builder::cartesianCoordinates))
            .constructor(CartesianCoordinates::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cartesianCoordinates").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CARTESIAN_COORDINATES_FIELD));

    private static final long serialVersionUID = 1L;

    private final CartesianCoordinates cartesianCoordinates;

    private final Type type;

    private PositionCoordinates(BuilderImpl builder) {
        this.cartesianCoordinates = builder.cartesianCoordinates;
        this.type = builder.type;
    }

    /**
     * <p>
     * Cartesian coordinates.
     * </p>
     * 
     * @return Cartesian coordinates.
     */
    public final CartesianCoordinates cartesianCoordinates() {
        return cartesianCoordinates;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cartesianCoordinates());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PositionCoordinates)) {
            return false;
        }
        PositionCoordinates other = (PositionCoordinates) obj;
        return Objects.equals(cartesianCoordinates(), other.cartesianCoordinates());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PositionCoordinates").add("CartesianCoordinates", cartesianCoordinates()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "cartesianCoordinates":
            return Optional.ofNullable(clazz.cast(cartesianCoordinates()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #cartesianCoordinates()} initialized to the given value.
     *
     * <p>
     * Cartesian coordinates.
     * </p>
     * 
     * @param cartesianCoordinates
     *        Cartesian coordinates.
     */
    public static PositionCoordinates fromCartesianCoordinates(CartesianCoordinates cartesianCoordinates) {
        return builder().cartesianCoordinates(cartesianCoordinates).build();
    }

    /**
     * Create an instance of this class with {@link #cartesianCoordinates()} initialized to the given value.
     *
     * <p>
     * Cartesian coordinates.
     * </p>
     * 
     * @param cartesianCoordinates
     *        Cartesian coordinates.
     */
    public static PositionCoordinates fromCartesianCoordinates(Consumer<CartesianCoordinates.Builder> cartesianCoordinates) {
        CartesianCoordinates.Builder builder = CartesianCoordinates.builder();
        cartesianCoordinates.accept(builder);
        return fromCartesianCoordinates(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PositionCoordinates, T> g) {
        return obj -> g.apply((PositionCoordinates) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PositionCoordinates> {
        /**
         * <p>
         * Cartesian coordinates.
         * </p>
         * 
         * @param cartesianCoordinates
         *        Cartesian coordinates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cartesianCoordinates(CartesianCoordinates cartesianCoordinates);

        /**
         * <p>
         * Cartesian coordinates.
         * </p>
         * This is a convenience method that creates an instance of the {@link CartesianCoordinates.Builder} avoiding
         * the need to create one manually via {@link CartesianCoordinates#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CartesianCoordinates.Builder#build()} is called immediately and
         * its result is passed to {@link #cartesianCoordinates(CartesianCoordinates)}.
         * 
         * @param cartesianCoordinates
         *        a consumer that will call methods on {@link CartesianCoordinates.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cartesianCoordinates(CartesianCoordinates)
         */
        default Builder cartesianCoordinates(Consumer<CartesianCoordinates.Builder> cartesianCoordinates) {
            return cartesianCoordinates(CartesianCoordinates.builder().applyMutation(cartesianCoordinates).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private CartesianCoordinates cartesianCoordinates;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(PositionCoordinates model) {
            cartesianCoordinates(model.cartesianCoordinates);
        }

        public final CartesianCoordinates.Builder getCartesianCoordinates() {
            return cartesianCoordinates != null ? cartesianCoordinates.toBuilder() : null;
        }

        public final void setCartesianCoordinates(CartesianCoordinates.BuilderImpl cartesianCoordinates) {
            Object oldValue = this.cartesianCoordinates;
            this.cartesianCoordinates = cartesianCoordinates != null ? cartesianCoordinates.build() : null;
            handleUnionValueChange(Type.CARTESIAN_COORDINATES, oldValue, this.cartesianCoordinates);
        }

        @Override
        public final Builder cartesianCoordinates(CartesianCoordinates cartesianCoordinates) {
            Object oldValue = this.cartesianCoordinates;
            this.cartesianCoordinates = cartesianCoordinates;
            handleUnionValueChange(Type.CARTESIAN_COORDINATES, oldValue, this.cartesianCoordinates);
            return this;
        }

        @Override
        public PositionCoordinates build() {
            return new PositionCoordinates(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see PositionCoordinates#type()
     */
    public enum Type {
        CARTESIAN_COORDINATES,

        UNKNOWN_TO_SDK_VERSION
    }
}
