/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ioteventsdata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteDetectorRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DeleteDetectorRequest> {
    private static final SdkField<String> MESSAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("messageId").getter(DeleteDetectorRequest.getter(DeleteDetectorRequest::messageId)).setter(DeleteDetectorRequest.setter(Builder::messageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("messageId").build()}).build();
    private static final SdkField<String> DETECTOR_MODEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("detectorModelName").getter(DeleteDetectorRequest.getter(DeleteDetectorRequest::detectorModelName)).setter(DeleteDetectorRequest.setter(Builder::detectorModelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorModelName").build()}).build();
    private static final SdkField<String> KEY_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("keyValue").getter(DeleteDetectorRequest.getter(DeleteDetectorRequest::keyValue)).setter(DeleteDetectorRequest.setter(Builder::keyValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyValue").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGE_ID_FIELD, DETECTOR_MODEL_NAME_FIELD, KEY_VALUE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String messageId;
    private final String detectorModelName;
    private final String keyValue;

    private DeleteDetectorRequest(BuilderImpl builder) {
        this.messageId = builder.messageId;
        this.detectorModelName = builder.detectorModelName;
        this.keyValue = builder.keyValue;
    }

    public final String messageId() {
        return this.messageId;
    }

    public final String detectorModelName() {
        return this.detectorModelName;
    }

    public final String keyValue() {
        return this.keyValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.messageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.detectorModelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyValue());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteDetectorRequest)) {
            return false;
        }
        DeleteDetectorRequest other = (DeleteDetectorRequest)obj;
        return Objects.equals(this.messageId(), other.messageId()) && Objects.equals(this.detectorModelName(), other.detectorModelName()) && Objects.equals(this.keyValue(), other.keyValue());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteDetectorRequest").add("MessageId", (Object)this.messageId()).add("DetectorModelName", (Object)this.detectorModelName()).add("KeyValue", (Object)this.keyValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "messageId": {
                return Optional.ofNullable(clazz.cast(this.messageId()));
            }
            case "detectorModelName": {
                return Optional.ofNullable(clazz.cast(this.detectorModelName()));
            }
            case "keyValue": {
                return Optional.ofNullable(clazz.cast(this.keyValue()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteDetectorRequest, T> g) {
        return obj -> g.apply((DeleteDetectorRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String messageId;
        private String detectorModelName;
        private String keyValue;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteDetectorRequest model) {
            this.messageId(model.messageId);
            this.detectorModelName(model.detectorModelName);
            this.keyValue(model.keyValue);
        }

        public final String getMessageId() {
            return this.messageId;
        }

        public final void setMessageId(String messageId) {
            this.messageId = messageId;
        }

        @Override
        public final Builder messageId(String messageId) {
            this.messageId = messageId;
            return this;
        }

        public final String getDetectorModelName() {
            return this.detectorModelName;
        }

        public final void setDetectorModelName(String detectorModelName) {
            this.detectorModelName = detectorModelName;
        }

        @Override
        public final Builder detectorModelName(String detectorModelName) {
            this.detectorModelName = detectorModelName;
            return this;
        }

        public final String getKeyValue() {
            return this.keyValue;
        }

        public final void setKeyValue(String keyValue) {
            this.keyValue = keyValue;
        }

        @Override
        public final Builder keyValue(String keyValue) {
            this.keyValue = keyValue;
            return this;
        }

        public DeleteDetectorRequest build() {
            return new DeleteDetectorRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DeleteDetectorRequest> {
        public Builder messageId(String var1);

        public Builder detectorModelName(String var1);

        public Builder keyValue(String var1);
    }
}

