/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ioteventsdata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ioteventsdata.model.DetectorStateDefinition;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateDetectorRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UpdateDetectorRequest> {
    private static final SdkField<String> MESSAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("messageId").getter(UpdateDetectorRequest.getter(UpdateDetectorRequest::messageId)).setter(UpdateDetectorRequest.setter(Builder::messageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("messageId").build()}).build();
    private static final SdkField<String> DETECTOR_MODEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("detectorModelName").getter(UpdateDetectorRequest.getter(UpdateDetectorRequest::detectorModelName)).setter(UpdateDetectorRequest.setter(Builder::detectorModelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorModelName").build()}).build();
    private static final SdkField<String> KEY_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("keyValue").getter(UpdateDetectorRequest.getter(UpdateDetectorRequest::keyValue)).setter(UpdateDetectorRequest.setter(Builder::keyValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyValue").build()}).build();
    private static final SdkField<DetectorStateDefinition> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("state").getter(UpdateDetectorRequest.getter(UpdateDetectorRequest::state)).setter(UpdateDetectorRequest.setter(Builder::state)).constructor(DetectorStateDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGE_ID_FIELD, DETECTOR_MODEL_NAME_FIELD, KEY_VALUE_FIELD, STATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String messageId;
    private final String detectorModelName;
    private final String keyValue;
    private final DetectorStateDefinition state;

    private UpdateDetectorRequest(BuilderImpl builder) {
        this.messageId = builder.messageId;
        this.detectorModelName = builder.detectorModelName;
        this.keyValue = builder.keyValue;
        this.state = builder.state;
    }

    public final String messageId() {
        return this.messageId;
    }

    public final String detectorModelName() {
        return this.detectorModelName;
    }

    public final String keyValue() {
        return this.keyValue;
    }

    public final DetectorStateDefinition state() {
        return this.state;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.messageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.detectorModelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.state());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDetectorRequest)) {
            return false;
        }
        UpdateDetectorRequest other = (UpdateDetectorRequest)obj;
        return Objects.equals(this.messageId(), other.messageId()) && Objects.equals(this.detectorModelName(), other.detectorModelName()) && Objects.equals(this.keyValue(), other.keyValue()) && Objects.equals(this.state(), other.state());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateDetectorRequest").add("MessageId", (Object)this.messageId()).add("DetectorModelName", (Object)this.detectorModelName()).add("KeyValue", (Object)this.keyValue()).add("State", (Object)this.state()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "messageId": {
                return Optional.ofNullable(clazz.cast(this.messageId()));
            }
            case "detectorModelName": {
                return Optional.ofNullable(clazz.cast(this.detectorModelName()));
            }
            case "keyValue": {
                return Optional.ofNullable(clazz.cast(this.keyValue()));
            }
            case "state": {
                return Optional.ofNullable(clazz.cast(this.state()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDetectorRequest, T> g) {
        return obj -> g.apply((UpdateDetectorRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String messageId;
        private String detectorModelName;
        private String keyValue;
        private DetectorStateDefinition state;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDetectorRequest model) {
            this.messageId(model.messageId);
            this.detectorModelName(model.detectorModelName);
            this.keyValue(model.keyValue);
            this.state(model.state);
        }

        public final String getMessageId() {
            return this.messageId;
        }

        public final void setMessageId(String messageId) {
            this.messageId = messageId;
        }

        @Override
        public final Builder messageId(String messageId) {
            this.messageId = messageId;
            return this;
        }

        public final String getDetectorModelName() {
            return this.detectorModelName;
        }

        public final void setDetectorModelName(String detectorModelName) {
            this.detectorModelName = detectorModelName;
        }

        @Override
        public final Builder detectorModelName(String detectorModelName) {
            this.detectorModelName = detectorModelName;
            return this;
        }

        public final String getKeyValue() {
            return this.keyValue;
        }

        public final void setKeyValue(String keyValue) {
            this.keyValue = keyValue;
        }

        @Override
        public final Builder keyValue(String keyValue) {
            this.keyValue = keyValue;
            return this;
        }

        public final DetectorStateDefinition.Builder getState() {
            return this.state != null ? this.state.toBuilder() : null;
        }

        public final void setState(DetectorStateDefinition.BuilderImpl state) {
            this.state = state != null ? state.build() : null;
        }

        @Override
        public final Builder state(DetectorStateDefinition state) {
            this.state = state;
            return this;
        }

        public UpdateDetectorRequest build() {
            return new UpdateDetectorRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UpdateDetectorRequest> {
        public Builder messageId(String var1);

        public Builder detectorModelName(String var1);

        public Builder keyValue(String var1);

        public Builder state(DetectorStateDefinition var1);

        default public Builder state(Consumer<DetectorStateDefinition.Builder> state) {
            return this.state((DetectorStateDefinition)((DetectorStateDefinition.Builder)DetectorStateDefinition.builder().applyMutation(state)).build());
        }
    }
}

