/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotevents.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the configuration information of email notifications.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EmailConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<EmailConfiguration.Builder, EmailConfiguration> {
    private static final SdkField<String> FROM_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("from")
            .getter(getter(EmailConfiguration::from)).setter(setter(Builder::from))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("from").build()).build();

    private static final SdkField<EmailContent> CONTENT_FIELD = SdkField.<EmailContent> builder(MarshallingType.SDK_POJO)
            .memberName("content").getter(getter(EmailConfiguration::content)).setter(setter(Builder::content))
            .constructor(EmailContent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("content").build()).build();

    private static final SdkField<EmailRecipients> RECIPIENTS_FIELD = SdkField
            .<EmailRecipients> builder(MarshallingType.SDK_POJO).memberName("recipients")
            .getter(getter(EmailConfiguration::recipients)).setter(setter(Builder::recipients))
            .constructor(EmailRecipients::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recipients").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FROM_FIELD, CONTENT_FIELD,
            RECIPIENTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String from;

    private final EmailContent content;

    private final EmailRecipients recipients;

    private EmailConfiguration(BuilderImpl builder) {
        this.from = builder.from;
        this.content = builder.content;
        this.recipients = builder.recipients;
    }

    /**
     * <p>
     * The email address that sends emails.
     * </p>
     * <important>
     * <p>
     * If you use the AWS IoT Events managed AWS Lambda function to manage your emails, you must <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-email-addresses.html">verify the email address
     * that sends emails in Amazon SES</a>.
     * </p>
     * </important>
     * 
     * @return The email address that sends emails.</p> <important>
     *         <p>
     *         If you use the AWS IoT Events managed AWS Lambda function to manage your emails, you must <a
     *         href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-email-addresses.html">verify the email
     *         address that sends emails in Amazon SES</a>.
     *         </p>
     */
    public final String from() {
        return from;
    }

    /**
     * <p>
     * Contains the subject and message of an email.
     * </p>
     * 
     * @return Contains the subject and message of an email.
     */
    public final EmailContent content() {
        return content;
    }

    /**
     * <p>
     * Contains the information of one or more recipients who receive the emails.
     * </p>
     * <important>
     * <p>
     * You must <a href="https://docs.aws.amazon.com/singlesignon/latest/userguide/addusers.html">add the users that
     * receive emails to your AWS SSO store</a>.
     * </p>
     * </important>
     * 
     * @return Contains the information of one or more recipients who receive the emails.</p> <important>
     *         <p>
     *         You must <a href="https://docs.aws.amazon.com/singlesignon/latest/userguide/addusers.html">add the users
     *         that receive emails to your AWS SSO store</a>.
     *         </p>
     */
    public final EmailRecipients recipients() {
        return recipients;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(from());
        hashCode = 31 * hashCode + Objects.hashCode(content());
        hashCode = 31 * hashCode + Objects.hashCode(recipients());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EmailConfiguration)) {
            return false;
        }
        EmailConfiguration other = (EmailConfiguration) obj;
        return Objects.equals(from(), other.from()) && Objects.equals(content(), other.content())
                && Objects.equals(recipients(), other.recipients());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EmailConfiguration").add("From", from()).add("Content", content())
                .add("Recipients", recipients()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "from":
            return Optional.ofNullable(clazz.cast(from()));
        case "content":
            return Optional.ofNullable(clazz.cast(content()));
        case "recipients":
            return Optional.ofNullable(clazz.cast(recipients()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EmailConfiguration, T> g) {
        return obj -> g.apply((EmailConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EmailConfiguration> {
        /**
         * <p>
         * The email address that sends emails.
         * </p>
         * <important>
         * <p>
         * If you use the AWS IoT Events managed AWS Lambda function to manage your emails, you must <a
         * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-email-addresses.html">verify the email
         * address that sends emails in Amazon SES</a>.
         * </p>
         * </important>
         * 
         * @param from
         *        The email address that sends emails.</p> <important>
         *        <p>
         *        If you use the AWS IoT Events managed AWS Lambda function to manage your emails, you must <a
         *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-email-addresses.html">verify the
         *        email address that sends emails in Amazon SES</a>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder from(String from);

        /**
         * <p>
         * Contains the subject and message of an email.
         * </p>
         * 
         * @param content
         *        Contains the subject and message of an email.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(EmailContent content);

        /**
         * <p>
         * Contains the subject and message of an email.
         * </p>
         * This is a convenience method that creates an instance of the {@link EmailContent.Builder} avoiding the need
         * to create one manually via {@link EmailContent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EmailContent.Builder#build()} is called immediately and its
         * result is passed to {@link #content(EmailContent)}.
         * 
         * @param content
         *        a consumer that will call methods on {@link EmailContent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #content(EmailContent)
         */
        default Builder content(Consumer<EmailContent.Builder> content) {
            return content(EmailContent.builder().applyMutation(content).build());
        }

        /**
         * <p>
         * Contains the information of one or more recipients who receive the emails.
         * </p>
         * <important>
         * <p>
         * You must <a href="https://docs.aws.amazon.com/singlesignon/latest/userguide/addusers.html">add the users that
         * receive emails to your AWS SSO store</a>.
         * </p>
         * </important>
         * 
         * @param recipients
         *        Contains the information of one or more recipients who receive the emails.</p> <important>
         *        <p>
         *        You must <a href="https://docs.aws.amazon.com/singlesignon/latest/userguide/addusers.html">add the
         *        users that receive emails to your AWS SSO store</a>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recipients(EmailRecipients recipients);

        /**
         * <p>
         * Contains the information of one or more recipients who receive the emails.
         * </p>
         * <important>
         * <p>
         * You must <a href="https://docs.aws.amazon.com/singlesignon/latest/userguide/addusers.html">add the users that
         * receive emails to your AWS SSO store</a>.
         * </p>
         * </important> This is a convenience method that creates an instance of the {@link EmailRecipients.Builder}
         * avoiding the need to create one manually via {@link EmailRecipients#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EmailRecipients.Builder#build()} is called immediately and its
         * result is passed to {@link #recipients(EmailRecipients)}.
         * 
         * @param recipients
         *        a consumer that will call methods on {@link EmailRecipients.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recipients(EmailRecipients)
         */
        default Builder recipients(Consumer<EmailRecipients.Builder> recipients) {
            return recipients(EmailRecipients.builder().applyMutation(recipients).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String from;

        private EmailContent content;

        private EmailRecipients recipients;

        private BuilderImpl() {
        }

        private BuilderImpl(EmailConfiguration model) {
            from(model.from);
            content(model.content);
            recipients(model.recipients);
        }

        public final String getFrom() {
            return from;
        }

        public final void setFrom(String from) {
            this.from = from;
        }

        @Override
        public final Builder from(String from) {
            this.from = from;
            return this;
        }

        public final EmailContent.Builder getContent() {
            return content != null ? content.toBuilder() : null;
        }

        public final void setContent(EmailContent.BuilderImpl content) {
            this.content = content != null ? content.build() : null;
        }

        @Override
        public final Builder content(EmailContent content) {
            this.content = content;
            return this;
        }

        public final EmailRecipients.Builder getRecipients() {
            return recipients != null ? recipients.toBuilder() : null;
        }

        public final void setRecipients(EmailRecipients.BuilderImpl recipients) {
            this.recipients = recipients != null ? recipients.build() : null;
        }

        @Override
        public final Builder recipients(EmailRecipients recipients) {
            this.recipients = recipients;
            return this;
        }

        @Override
        public EmailConfiguration build() {
            return new EmailConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
