/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotevents.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateInputRequest extends IotEventsRequest implements
        ToCopyableBuilder<CreateInputRequest.Builder, CreateInputRequest> {
    private static final SdkField<String> INPUT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("inputName").getter(getter(CreateInputRequest::inputName)).setter(setter(Builder::inputName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputName").build()).build();

    private static final SdkField<String> INPUT_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("inputDescription").getter(getter(CreateInputRequest::inputDescription))
            .setter(setter(Builder::inputDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputDescription").build()).build();

    private static final SdkField<InputDefinition> INPUT_DEFINITION_FIELD = SdkField
            .<InputDefinition> builder(MarshallingType.SDK_POJO).memberName("inputDefinition")
            .getter(getter(CreateInputRequest::inputDefinition)).setter(setter(Builder::inputDefinition))
            .constructor(InputDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputDefinition").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(CreateInputRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_NAME_FIELD,
            INPUT_DESCRIPTION_FIELD, INPUT_DEFINITION_FIELD, TAGS_FIELD));

    private final String inputName;

    private final String inputDescription;

    private final InputDefinition inputDefinition;

    private final List<Tag> tags;

    private CreateInputRequest(BuilderImpl builder) {
        super(builder);
        this.inputName = builder.inputName;
        this.inputDescription = builder.inputDescription;
        this.inputDefinition = builder.inputDefinition;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name you want to give to the input.
     * </p>
     * 
     * @return The name you want to give to the input.
     */
    public final String inputName() {
        return inputName;
    }

    /**
     * <p>
     * A brief description of the input.
     * </p>
     * 
     * @return A brief description of the input.
     */
    public final String inputDescription() {
        return inputDescription;
    }

    /**
     * <p>
     * The definition of the input.
     * </p>
     * 
     * @return The definition of the input.
     */
    public final InputDefinition inputDefinition() {
        return inputDefinition;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Metadata that can be used to manage the input.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Metadata that can be used to manage the input.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(inputName());
        hashCode = 31 * hashCode + Objects.hashCode(inputDescription());
        hashCode = 31 * hashCode + Objects.hashCode(inputDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateInputRequest)) {
            return false;
        }
        CreateInputRequest other = (CreateInputRequest) obj;
        return Objects.equals(inputName(), other.inputName()) && Objects.equals(inputDescription(), other.inputDescription())
                && Objects.equals(inputDefinition(), other.inputDefinition()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateInputRequest").add("InputName", inputName()).add("InputDescription", inputDescription())
                .add("InputDefinition", inputDefinition()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "inputName":
            return Optional.ofNullable(clazz.cast(inputName()));
        case "inputDescription":
            return Optional.ofNullable(clazz.cast(inputDescription()));
        case "inputDefinition":
            return Optional.ofNullable(clazz.cast(inputDefinition()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateInputRequest, T> g) {
        return obj -> g.apply((CreateInputRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotEventsRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateInputRequest> {
        /**
         * <p>
         * The name you want to give to the input.
         * </p>
         * 
         * @param inputName
         *        The name you want to give to the input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputName(String inputName);

        /**
         * <p>
         * A brief description of the input.
         * </p>
         * 
         * @param inputDescription
         *        A brief description of the input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputDescription(String inputDescription);

        /**
         * <p>
         * The definition of the input.
         * </p>
         * 
         * @param inputDefinition
         *        The definition of the input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputDefinition(InputDefinition inputDefinition);

        /**
         * <p>
         * The definition of the input.
         * </p>
         * This is a convenience method that creates an instance of the {@link InputDefinition.Builder} avoiding the
         * need to create one manually via {@link InputDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InputDefinition.Builder#build()} is called immediately and its
         * result is passed to {@link #inputDefinition(InputDefinition)}.
         * 
         * @param inputDefinition
         *        a consumer that will call methods on {@link InputDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputDefinition(InputDefinition)
         */
        default Builder inputDefinition(Consumer<InputDefinition.Builder> inputDefinition) {
            return inputDefinition(InputDefinition.builder().applyMutation(inputDefinition).build());
        }

        /**
         * <p>
         * Metadata that can be used to manage the input.
         * </p>
         * 
         * @param tags
         *        Metadata that can be used to manage the input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Metadata that can be used to manage the input.
         * </p>
         * 
         * @param tags
         *        Metadata that can be used to manage the input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Metadata that can be used to manage the input.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotevents.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.iotevents.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotevents.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotevents.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotEventsRequest.BuilderImpl implements Builder {
        private String inputName;

        private String inputDescription;

        private InputDefinition inputDefinition;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateInputRequest model) {
            super(model);
            inputName(model.inputName);
            inputDescription(model.inputDescription);
            inputDefinition(model.inputDefinition);
            tags(model.tags);
        }

        public final String getInputName() {
            return inputName;
        }

        public final void setInputName(String inputName) {
            this.inputName = inputName;
        }

        @Override
        public final Builder inputName(String inputName) {
            this.inputName = inputName;
            return this;
        }

        public final String getInputDescription() {
            return inputDescription;
        }

        public final void setInputDescription(String inputDescription) {
            this.inputDescription = inputDescription;
        }

        @Override
        public final Builder inputDescription(String inputDescription) {
            this.inputDescription = inputDescription;
            return this;
        }

        public final InputDefinition.Builder getInputDefinition() {
            return inputDefinition != null ? inputDefinition.toBuilder() : null;
        }

        public final void setInputDefinition(InputDefinition.BuilderImpl inputDefinition) {
            this.inputDefinition = inputDefinition != null ? inputDefinition.build() : null;
        }

        @Override
        public final Builder inputDefinition(InputDefinition inputDefinition) {
            this.inputDefinition = inputDefinition;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateInputRequest build() {
            return new CreateInputRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
