/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotevents.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAlarmModelRequest extends IotEventsRequest implements
        ToCopyableBuilder<CreateAlarmModelRequest.Builder, CreateAlarmModelRequest> {
    private static final SdkField<String> ALARM_MODEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("alarmModelName").getter(getter(CreateAlarmModelRequest::alarmModelName))
            .setter(setter(Builder::alarmModelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alarmModelName").build()).build();

    private static final SdkField<String> ALARM_MODEL_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("alarmModelDescription").getter(getter(CreateAlarmModelRequest::alarmModelDescription))
            .setter(setter(Builder::alarmModelDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alarmModelDescription").build())
            .build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(CreateAlarmModelRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(CreateAlarmModelRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("key")
            .getter(getter(CreateAlarmModelRequest::key)).setter(setter(Builder::key))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("key").build()).build();

    private static final SdkField<Integer> SEVERITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("severity").getter(getter(CreateAlarmModelRequest::severity)).setter(setter(Builder::severity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("severity").build()).build();

    private static final SdkField<AlarmRule> ALARM_RULE_FIELD = SdkField.<AlarmRule> builder(MarshallingType.SDK_POJO)
            .memberName("alarmRule").getter(getter(CreateAlarmModelRequest::alarmRule)).setter(setter(Builder::alarmRule))
            .constructor(AlarmRule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alarmRule").build()).build();

    private static final SdkField<AlarmNotification> ALARM_NOTIFICATION_FIELD = SdkField
            .<AlarmNotification> builder(MarshallingType.SDK_POJO).memberName("alarmNotification")
            .getter(getter(CreateAlarmModelRequest::alarmNotification)).setter(setter(Builder::alarmNotification))
            .constructor(AlarmNotification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alarmNotification").build()).build();

    private static final SdkField<AlarmEventActions> ALARM_EVENT_ACTIONS_FIELD = SdkField
            .<AlarmEventActions> builder(MarshallingType.SDK_POJO).memberName("alarmEventActions")
            .getter(getter(CreateAlarmModelRequest::alarmEventActions)).setter(setter(Builder::alarmEventActions))
            .constructor(AlarmEventActions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alarmEventActions").build()).build();

    private static final SdkField<AlarmCapabilities> ALARM_CAPABILITIES_FIELD = SdkField
            .<AlarmCapabilities> builder(MarshallingType.SDK_POJO).memberName("alarmCapabilities")
            .getter(getter(CreateAlarmModelRequest::alarmCapabilities)).setter(setter(Builder::alarmCapabilities))
            .constructor(AlarmCapabilities::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alarmCapabilities").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALARM_MODEL_NAME_FIELD,
            ALARM_MODEL_DESCRIPTION_FIELD, ROLE_ARN_FIELD, TAGS_FIELD, KEY_FIELD, SEVERITY_FIELD, ALARM_RULE_FIELD,
            ALARM_NOTIFICATION_FIELD, ALARM_EVENT_ACTIONS_FIELD, ALARM_CAPABILITIES_FIELD));

    private final String alarmModelName;

    private final String alarmModelDescription;

    private final String roleArn;

    private final List<Tag> tags;

    private final String key;

    private final Integer severity;

    private final AlarmRule alarmRule;

    private final AlarmNotification alarmNotification;

    private final AlarmEventActions alarmEventActions;

    private final AlarmCapabilities alarmCapabilities;

    private CreateAlarmModelRequest(BuilderImpl builder) {
        super(builder);
        this.alarmModelName = builder.alarmModelName;
        this.alarmModelDescription = builder.alarmModelDescription;
        this.roleArn = builder.roleArn;
        this.tags = builder.tags;
        this.key = builder.key;
        this.severity = builder.severity;
        this.alarmRule = builder.alarmRule;
        this.alarmNotification = builder.alarmNotification;
        this.alarmEventActions = builder.alarmEventActions;
        this.alarmCapabilities = builder.alarmCapabilities;
    }

    /**
     * <p>
     * A unique name that helps you identify the alarm model. You can't change this name after you create the alarm
     * model.
     * </p>
     * 
     * @return A unique name that helps you identify the alarm model. You can't change this name after you create the
     *         alarm model.
     */
    public final String alarmModelName() {
        return alarmModelName;
    }

    /**
     * <p>
     * A description that tells you what the alarm model detects.
     * </p>
     * 
     * @return A description that tells you what the alarm model detects.
     */
    public final String alarmModelDescription() {
        return alarmModelDescription;
    }

    /**
     * <p>
     * The ARN of the IAM role that allows the alarm to perform actions and access AWS resources. For more information,
     * see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
     * (ARNs)</a> in the <i>AWS General Reference</i>.
     * </p>
     * 
     * @return The ARN of the IAM role that allows the alarm to perform actions and access AWS resources. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
     *         (ARNs)</a> in the <i>AWS General Reference</i>.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of key-value pairs that contain metadata for the alarm model. The tags help you manage the alarm model.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/iotevents/latest/developerguide/tagging-iotevents.html">Tagging your AWS IoT
     * Events resources</a> in the <i>AWS IoT Events Developer Guide</i>.
     * </p>
     * <p>
     * You can create up to 50 tags for one alarm model.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of key-value pairs that contain metadata for the alarm model. The tags help you manage the alarm
     *         model. For more information, see <a
     *         href="https://docs.aws.amazon.com/iotevents/latest/developerguide/tagging-iotevents.html">Tagging your
     *         AWS IoT Events resources</a> in the <i>AWS IoT Events Developer Guide</i>.</p>
     *         <p>
     *         You can create up to 50 tags for one alarm model.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * An input attribute used as a key to create an alarm. AWS IoT Events routes <a
     * href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_Input.html">inputs</a> associated with this
     * key to the alarm.
     * </p>
     * 
     * @return An input attribute used as a key to create an alarm. AWS IoT Events routes <a
     *         href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_Input.html">inputs</a> associated
     *         with this key to the alarm.
     */
    public final String key() {
        return key;
    }

    /**
     * <p>
     * A non-negative integer that reflects the severity level of the alarm.
     * </p>
     * 
     * @return A non-negative integer that reflects the severity level of the alarm.
     */
    public final Integer severity() {
        return severity;
    }

    /**
     * <p>
     * Defines when your alarm is invoked.
     * </p>
     * 
     * @return Defines when your alarm is invoked.
     */
    public final AlarmRule alarmRule() {
        return alarmRule;
    }

    /**
     * <p>
     * Contains information about one or more notification actions.
     * </p>
     * 
     * @return Contains information about one or more notification actions.
     */
    public final AlarmNotification alarmNotification() {
        return alarmNotification;
    }

    /**
     * <p>
     * Contains information about one or more alarm actions.
     * </p>
     * 
     * @return Contains information about one or more alarm actions.
     */
    public final AlarmEventActions alarmEventActions() {
        return alarmEventActions;
    }

    /**
     * <p>
     * Contains the configuration information of alarm state changes.
     * </p>
     * 
     * @return Contains the configuration information of alarm state changes.
     */
    public final AlarmCapabilities alarmCapabilities() {
        return alarmCapabilities;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(alarmModelName());
        hashCode = 31 * hashCode + Objects.hashCode(alarmModelDescription());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(key());
        hashCode = 31 * hashCode + Objects.hashCode(severity());
        hashCode = 31 * hashCode + Objects.hashCode(alarmRule());
        hashCode = 31 * hashCode + Objects.hashCode(alarmNotification());
        hashCode = 31 * hashCode + Objects.hashCode(alarmEventActions());
        hashCode = 31 * hashCode + Objects.hashCode(alarmCapabilities());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAlarmModelRequest)) {
            return false;
        }
        CreateAlarmModelRequest other = (CreateAlarmModelRequest) obj;
        return Objects.equals(alarmModelName(), other.alarmModelName())
                && Objects.equals(alarmModelDescription(), other.alarmModelDescription())
                && Objects.equals(roleArn(), other.roleArn()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(key(), other.key())
                && Objects.equals(severity(), other.severity()) && Objects.equals(alarmRule(), other.alarmRule())
                && Objects.equals(alarmNotification(), other.alarmNotification())
                && Objects.equals(alarmEventActions(), other.alarmEventActions())
                && Objects.equals(alarmCapabilities(), other.alarmCapabilities());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateAlarmModelRequest").add("AlarmModelName", alarmModelName())
                .add("AlarmModelDescription", alarmModelDescription()).add("RoleArn", roleArn())
                .add("Tags", hasTags() ? tags() : null).add("Key", key()).add("Severity", severity())
                .add("AlarmRule", alarmRule()).add("AlarmNotification", alarmNotification())
                .add("AlarmEventActions", alarmEventActions()).add("AlarmCapabilities", alarmCapabilities()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "alarmModelName":
            return Optional.ofNullable(clazz.cast(alarmModelName()));
        case "alarmModelDescription":
            return Optional.ofNullable(clazz.cast(alarmModelDescription()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "key":
            return Optional.ofNullable(clazz.cast(key()));
        case "severity":
            return Optional.ofNullable(clazz.cast(severity()));
        case "alarmRule":
            return Optional.ofNullable(clazz.cast(alarmRule()));
        case "alarmNotification":
            return Optional.ofNullable(clazz.cast(alarmNotification()));
        case "alarmEventActions":
            return Optional.ofNullable(clazz.cast(alarmEventActions()));
        case "alarmCapabilities":
            return Optional.ofNullable(clazz.cast(alarmCapabilities()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateAlarmModelRequest, T> g) {
        return obj -> g.apply((CreateAlarmModelRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotEventsRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateAlarmModelRequest> {
        /**
         * <p>
         * A unique name that helps you identify the alarm model. You can't change this name after you create the alarm
         * model.
         * </p>
         * 
         * @param alarmModelName
         *        A unique name that helps you identify the alarm model. You can't change this name after you create the
         *        alarm model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmModelName(String alarmModelName);

        /**
         * <p>
         * A description that tells you what the alarm model detects.
         * </p>
         * 
         * @param alarmModelDescription
         *        A description that tells you what the alarm model detects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmModelDescription(String alarmModelDescription);

        /**
         * <p>
         * The ARN of the IAM role that allows the alarm to perform actions and access AWS resources. For more
         * information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
         * Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.
         * </p>
         * 
         * @param roleArn
         *        The ARN of the IAM role that allows the alarm to perform actions and access AWS resources. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
         *        Names (ARNs)</a> in the <i>AWS General Reference</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * A list of key-value pairs that contain metadata for the alarm model. The tags help you manage the alarm
         * model. For more information, see <a
         * href="https://docs.aws.amazon.com/iotevents/latest/developerguide/tagging-iotevents.html">Tagging your AWS
         * IoT Events resources</a> in the <i>AWS IoT Events Developer Guide</i>.
         * </p>
         * <p>
         * You can create up to 50 tags for one alarm model.
         * </p>
         * 
         * @param tags
         *        A list of key-value pairs that contain metadata for the alarm model. The tags help you manage the
         *        alarm model. For more information, see <a
         *        href="https://docs.aws.amazon.com/iotevents/latest/developerguide/tagging-iotevents.html">Tagging your
         *        AWS IoT Events resources</a> in the <i>AWS IoT Events Developer Guide</i>.</p>
         *        <p>
         *        You can create up to 50 tags for one alarm model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of key-value pairs that contain metadata for the alarm model. The tags help you manage the alarm
         * model. For more information, see <a
         * href="https://docs.aws.amazon.com/iotevents/latest/developerguide/tagging-iotevents.html">Tagging your AWS
         * IoT Events resources</a> in the <i>AWS IoT Events Developer Guide</i>.
         * </p>
         * <p>
         * You can create up to 50 tags for one alarm model.
         * </p>
         * 
         * @param tags
         *        A list of key-value pairs that contain metadata for the alarm model. The tags help you manage the
         *        alarm model. For more information, see <a
         *        href="https://docs.aws.amazon.com/iotevents/latest/developerguide/tagging-iotevents.html">Tagging your
         *        AWS IoT Events resources</a> in the <i>AWS IoT Events Developer Guide</i>.</p>
         *        <p>
         *        You can create up to 50 tags for one alarm model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of key-value pairs that contain metadata for the alarm model. The tags help you manage the alarm
         * model. For more information, see <a
         * href="https://docs.aws.amazon.com/iotevents/latest/developerguide/tagging-iotevents.html">Tagging your AWS
         * IoT Events resources</a> in the <i>AWS IoT Events Developer Guide</i>.
         * </p>
         * <p>
         * You can create up to 50 tags for one alarm model.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotevents.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.iotevents.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotevents.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotevents.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * An input attribute used as a key to create an alarm. AWS IoT Events routes <a
         * href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_Input.html">inputs</a> associated with
         * this key to the alarm.
         * </p>
         * 
         * @param key
         *        An input attribute used as a key to create an alarm. AWS IoT Events routes <a
         *        href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_Input.html">inputs</a> associated
         *        with this key to the alarm.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);

        /**
         * <p>
         * A non-negative integer that reflects the severity level of the alarm.
         * </p>
         * 
         * @param severity
         *        A non-negative integer that reflects the severity level of the alarm.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder severity(Integer severity);

        /**
         * <p>
         * Defines when your alarm is invoked.
         * </p>
         * 
         * @param alarmRule
         *        Defines when your alarm is invoked.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmRule(AlarmRule alarmRule);

        /**
         * <p>
         * Defines when your alarm is invoked.
         * </p>
         * This is a convenience method that creates an instance of the {@link AlarmRule.Builder} avoiding the need to
         * create one manually via {@link AlarmRule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AlarmRule.Builder#build()} is called immediately and its result
         * is passed to {@link #alarmRule(AlarmRule)}.
         * 
         * @param alarmRule
         *        a consumer that will call methods on {@link AlarmRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #alarmRule(AlarmRule)
         */
        default Builder alarmRule(Consumer<AlarmRule.Builder> alarmRule) {
            return alarmRule(AlarmRule.builder().applyMutation(alarmRule).build());
        }

        /**
         * <p>
         * Contains information about one or more notification actions.
         * </p>
         * 
         * @param alarmNotification
         *        Contains information about one or more notification actions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmNotification(AlarmNotification alarmNotification);

        /**
         * <p>
         * Contains information about one or more notification actions.
         * </p>
         * This is a convenience method that creates an instance of the {@link AlarmNotification.Builder} avoiding the
         * need to create one manually via {@link AlarmNotification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AlarmNotification.Builder#build()} is called immediately and its
         * result is passed to {@link #alarmNotification(AlarmNotification)}.
         * 
         * @param alarmNotification
         *        a consumer that will call methods on {@link AlarmNotification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #alarmNotification(AlarmNotification)
         */
        default Builder alarmNotification(Consumer<AlarmNotification.Builder> alarmNotification) {
            return alarmNotification(AlarmNotification.builder().applyMutation(alarmNotification).build());
        }

        /**
         * <p>
         * Contains information about one or more alarm actions.
         * </p>
         * 
         * @param alarmEventActions
         *        Contains information about one or more alarm actions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmEventActions(AlarmEventActions alarmEventActions);

        /**
         * <p>
         * Contains information about one or more alarm actions.
         * </p>
         * This is a convenience method that creates an instance of the {@link AlarmEventActions.Builder} avoiding the
         * need to create one manually via {@link AlarmEventActions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AlarmEventActions.Builder#build()} is called immediately and its
         * result is passed to {@link #alarmEventActions(AlarmEventActions)}.
         * 
         * @param alarmEventActions
         *        a consumer that will call methods on {@link AlarmEventActions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #alarmEventActions(AlarmEventActions)
         */
        default Builder alarmEventActions(Consumer<AlarmEventActions.Builder> alarmEventActions) {
            return alarmEventActions(AlarmEventActions.builder().applyMutation(alarmEventActions).build());
        }

        /**
         * <p>
         * Contains the configuration information of alarm state changes.
         * </p>
         * 
         * @param alarmCapabilities
         *        Contains the configuration information of alarm state changes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmCapabilities(AlarmCapabilities alarmCapabilities);

        /**
         * <p>
         * Contains the configuration information of alarm state changes.
         * </p>
         * This is a convenience method that creates an instance of the {@link AlarmCapabilities.Builder} avoiding the
         * need to create one manually via {@link AlarmCapabilities#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AlarmCapabilities.Builder#build()} is called immediately and its
         * result is passed to {@link #alarmCapabilities(AlarmCapabilities)}.
         * 
         * @param alarmCapabilities
         *        a consumer that will call methods on {@link AlarmCapabilities.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #alarmCapabilities(AlarmCapabilities)
         */
        default Builder alarmCapabilities(Consumer<AlarmCapabilities.Builder> alarmCapabilities) {
            return alarmCapabilities(AlarmCapabilities.builder().applyMutation(alarmCapabilities).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotEventsRequest.BuilderImpl implements Builder {
        private String alarmModelName;

        private String alarmModelDescription;

        private String roleArn;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String key;

        private Integer severity;

        private AlarmRule alarmRule;

        private AlarmNotification alarmNotification;

        private AlarmEventActions alarmEventActions;

        private AlarmCapabilities alarmCapabilities;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAlarmModelRequest model) {
            super(model);
            alarmModelName(model.alarmModelName);
            alarmModelDescription(model.alarmModelDescription);
            roleArn(model.roleArn);
            tags(model.tags);
            key(model.key);
            severity(model.severity);
            alarmRule(model.alarmRule);
            alarmNotification(model.alarmNotification);
            alarmEventActions(model.alarmEventActions);
            alarmCapabilities(model.alarmCapabilities);
        }

        public final String getAlarmModelName() {
            return alarmModelName;
        }

        public final void setAlarmModelName(String alarmModelName) {
            this.alarmModelName = alarmModelName;
        }

        @Override
        public final Builder alarmModelName(String alarmModelName) {
            this.alarmModelName = alarmModelName;
            return this;
        }

        public final String getAlarmModelDescription() {
            return alarmModelDescription;
        }

        public final void setAlarmModelDescription(String alarmModelDescription) {
            this.alarmModelDescription = alarmModelDescription;
        }

        @Override
        public final Builder alarmModelDescription(String alarmModelDescription) {
            this.alarmModelDescription = alarmModelDescription;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getKey() {
            return key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final Integer getSeverity() {
            return severity;
        }

        public final void setSeverity(Integer severity) {
            this.severity = severity;
        }

        @Override
        public final Builder severity(Integer severity) {
            this.severity = severity;
            return this;
        }

        public final AlarmRule.Builder getAlarmRule() {
            return alarmRule != null ? alarmRule.toBuilder() : null;
        }

        public final void setAlarmRule(AlarmRule.BuilderImpl alarmRule) {
            this.alarmRule = alarmRule != null ? alarmRule.build() : null;
        }

        @Override
        public final Builder alarmRule(AlarmRule alarmRule) {
            this.alarmRule = alarmRule;
            return this;
        }

        public final AlarmNotification.Builder getAlarmNotification() {
            return alarmNotification != null ? alarmNotification.toBuilder() : null;
        }

        public final void setAlarmNotification(AlarmNotification.BuilderImpl alarmNotification) {
            this.alarmNotification = alarmNotification != null ? alarmNotification.build() : null;
        }

        @Override
        public final Builder alarmNotification(AlarmNotification alarmNotification) {
            this.alarmNotification = alarmNotification;
            return this;
        }

        public final AlarmEventActions.Builder getAlarmEventActions() {
            return alarmEventActions != null ? alarmEventActions.toBuilder() : null;
        }

        public final void setAlarmEventActions(AlarmEventActions.BuilderImpl alarmEventActions) {
            this.alarmEventActions = alarmEventActions != null ? alarmEventActions.build() : null;
        }

        @Override
        public final Builder alarmEventActions(AlarmEventActions alarmEventActions) {
            this.alarmEventActions = alarmEventActions;
            return this;
        }

        public final AlarmCapabilities.Builder getAlarmCapabilities() {
            return alarmCapabilities != null ? alarmCapabilities.toBuilder() : null;
        }

        public final void setAlarmCapabilities(AlarmCapabilities.BuilderImpl alarmCapabilities) {
            this.alarmCapabilities = alarmCapabilities != null ? alarmCapabilities.build() : null;
        }

        @Override
        public final Builder alarmCapabilities(AlarmCapabilities alarmCapabilities) {
            this.alarmCapabilities = alarmCapabilities;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAlarmModelRequest build() {
            return new CreateAlarmModelRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
