/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotanalytics.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotanalytics.model.IoTAnalyticsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeDatastoreRequest
extends IoTAnalyticsRequest
implements ToCopyableBuilder<Builder, DescribeDatastoreRequest> {
    private static final SdkField<String> DATASTORE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("datastoreName").getter(DescribeDatastoreRequest.getter(DescribeDatastoreRequest::datastoreName)).setter(DescribeDatastoreRequest.setter(Builder::datastoreName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("datastoreName").build()}).build();
    private static final SdkField<Boolean> INCLUDE_STATISTICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("includeStatistics").getter(DescribeDatastoreRequest.getter(DescribeDatastoreRequest::includeStatistics)).setter(DescribeDatastoreRequest.setter(Builder::includeStatistics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("includeStatistics").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASTORE_NAME_FIELD, INCLUDE_STATISTICS_FIELD));
    private final String datastoreName;
    private final Boolean includeStatistics;

    private DescribeDatastoreRequest(BuilderImpl builder) {
        super(builder);
        this.datastoreName = builder.datastoreName;
        this.includeStatistics = builder.includeStatistics;
    }

    public final String datastoreName() {
        return this.datastoreName;
    }

    public final Boolean includeStatistics() {
        return this.includeStatistics;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.datastoreName());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeStatistics());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDatastoreRequest)) {
            return false;
        }
        DescribeDatastoreRequest other = (DescribeDatastoreRequest)((Object)obj);
        return Objects.equals(this.datastoreName(), other.datastoreName()) && Objects.equals(this.includeStatistics(), other.includeStatistics());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeDatastoreRequest").add("DatastoreName", (Object)this.datastoreName()).add("IncludeStatistics", (Object)this.includeStatistics()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "datastoreName": {
                return Optional.ofNullable(clazz.cast(this.datastoreName()));
            }
            case "includeStatistics": {
                return Optional.ofNullable(clazz.cast(this.includeStatistics()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDatastoreRequest, T> g) {
        return obj -> g.apply((DescribeDatastoreRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTAnalyticsRequest.BuilderImpl
    implements Builder {
        private String datastoreName;
        private Boolean includeStatistics;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDatastoreRequest model) {
            super(model);
            this.datastoreName(model.datastoreName);
            this.includeStatistics(model.includeStatistics);
        }

        public final String getDatastoreName() {
            return this.datastoreName;
        }

        public final void setDatastoreName(String datastoreName) {
            this.datastoreName = datastoreName;
        }

        @Override
        public final Builder datastoreName(String datastoreName) {
            this.datastoreName = datastoreName;
            return this;
        }

        public final Boolean getIncludeStatistics() {
            return this.includeStatistics;
        }

        public final void setIncludeStatistics(Boolean includeStatistics) {
            this.includeStatistics = includeStatistics;
        }

        @Override
        public final Builder includeStatistics(Boolean includeStatistics) {
            this.includeStatistics = includeStatistics;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeDatastoreRequest build() {
            return new DescribeDatastoreRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IoTAnalyticsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeDatastoreRequest> {
        public Builder datastoreName(String var1);

        public Builder includeStatistics(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

