/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot1clickdevices.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.iot1clickdevices.model.Iot1ClickDevicesRequest;
import software.amazon.awssdk.services.iot1clickdevices.model.___mapOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FinalizeDeviceClaimRequest
extends Iot1ClickDevicesRequest
implements ToCopyableBuilder<Builder, FinalizeDeviceClaimRequest> {
    private static final SdkField<String> DEVICE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeviceId").getter(FinalizeDeviceClaimRequest.getter(FinalizeDeviceClaimRequest::deviceId)).setter(FinalizeDeviceClaimRequest.setter(Builder::deviceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("deviceId").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(FinalizeDeviceClaimRequest.getter(FinalizeDeviceClaimRequest::tags)).setter(FinalizeDeviceClaimRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_ID_FIELD, TAGS_FIELD));
    private final String deviceId;
    private final Map<String, String> tags;

    private FinalizeDeviceClaimRequest(BuilderImpl builder) {
        super(builder);
        this.deviceId = builder.deviceId;
        this.tags = builder.tags;
    }

    public final String deviceId() {
        return this.deviceId;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FinalizeDeviceClaimRequest)) {
            return false;
        }
        FinalizeDeviceClaimRequest other = (FinalizeDeviceClaimRequest)((Object)obj);
        return Objects.equals(this.deviceId(), other.deviceId()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"FinalizeDeviceClaimRequest").add("DeviceId", (Object)this.deviceId()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeviceId": {
                return Optional.ofNullable(clazz.cast(this.deviceId()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FinalizeDeviceClaimRequest, T> g) {
        return obj -> g.apply((FinalizeDeviceClaimRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Iot1ClickDevicesRequest.BuilderImpl
    implements Builder {
        private String deviceId;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FinalizeDeviceClaimRequest model) {
            super(model);
            this.deviceId(model.deviceId);
            this.tags(model.tags);
        }

        public final String getDeviceId() {
            return this.deviceId;
        }

        public final void setDeviceId(String deviceId) {
            this.deviceId = deviceId;
        }

        @Override
        public final Builder deviceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = ___mapOf__stringCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = ___mapOf__stringCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public FinalizeDeviceClaimRequest build() {
            return new FinalizeDeviceClaimRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Iot1ClickDevicesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, FinalizeDeviceClaimRequest> {
        public Builder deviceId(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

