/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot1clickdevices.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeviceMethod implements SdkPojo, Serializable, ToCopyableBuilder<DeviceMethod.Builder, DeviceMethod> {
    private static final SdkField<String> DEVICE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceType").getter(getter(DeviceMethod::deviceType)).setter(setter(Builder::deviceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceType").build()).build();

    private static final SdkField<String> METHOD_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MethodName").getter(getter(DeviceMethod::methodName)).setter(setter(Builder::methodName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("methodName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_TYPE_FIELD,
            METHOD_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String deviceType;

    private final String methodName;

    private DeviceMethod(BuilderImpl builder) {
        this.deviceType = builder.deviceType;
        this.methodName = builder.methodName;
    }

    /**
     * <p>
     * The type of the device, such as "button".
     * </p>
     * 
     * @return The type of the device, such as "button".
     */
    public final String deviceType() {
        return deviceType;
    }

    /**
     * <p>
     * The name of the method applicable to the deviceType.
     * </p>
     * 
     * @return The name of the method applicable to the deviceType.
     */
    public final String methodName() {
        return methodName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deviceType());
        hashCode = 31 * hashCode + Objects.hashCode(methodName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeviceMethod)) {
            return false;
        }
        DeviceMethod other = (DeviceMethod) obj;
        return Objects.equals(deviceType(), other.deviceType()) && Objects.equals(methodName(), other.methodName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeviceMethod").add("DeviceType", deviceType()).add("MethodName", methodName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeviceType":
            return Optional.ofNullable(clazz.cast(deviceType()));
        case "MethodName":
            return Optional.ofNullable(clazz.cast(methodName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeviceMethod, T> g) {
        return obj -> g.apply((DeviceMethod) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeviceMethod> {
        /**
         * <p>
         * The type of the device, such as "button".
         * </p>
         * 
         * @param deviceType
         *        The type of the device, such as "button".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceType(String deviceType);

        /**
         * <p>
         * The name of the method applicable to the deviceType.
         * </p>
         * 
         * @param methodName
         *        The name of the method applicable to the deviceType.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder methodName(String methodName);
    }

    static final class BuilderImpl implements Builder {
        private String deviceType;

        private String methodName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeviceMethod model) {
            deviceType(model.deviceType);
            methodName(model.methodName);
        }

        public final String getDeviceType() {
            return deviceType;
        }

        public final void setDeviceType(String deviceType) {
            this.deviceType = deviceType;
        }

        @Override
        public final Builder deviceType(String deviceType) {
            this.deviceType = deviceType;
            return this;
        }

        public final String getMethodName() {
            return methodName;
        }

        public final void setMethodName(String methodName) {
            this.methodName = methodName;
        }

        @Override
        public final Builder methodName(String methodName) {
            this.methodName = methodName;
            return this;
        }

        @Override
        public DeviceMethod build() {
            return new DeviceMethod(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
