/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iot.IotClient;
import software.amazon.awssdk.services.iot.internal.UserAgentUtils;
import software.amazon.awssdk.services.iot.model.AuditMitigationActionsTaskMetadata;
import software.amazon.awssdk.services.iot.model.ListAuditMitigationActionsTasksRequest;
import software.amazon.awssdk.services.iot.model.ListAuditMitigationActionsTasksResponse;

public class ListAuditMitigationActionsTasksIterable
implements SdkIterable<ListAuditMitigationActionsTasksResponse> {
    private final IotClient client;
    private final ListAuditMitigationActionsTasksRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAuditMitigationActionsTasksIterable(IotClient client, ListAuditMitigationActionsTasksRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAuditMitigationActionsTasksResponseFetcher();
    }

    public Iterator<ListAuditMitigationActionsTasksResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AuditMitigationActionsTaskMetadata> tasks() {
        Function<ListAuditMitigationActionsTasksResponse, Iterator> getIterator = response -> {
            if (response != null && response.tasks() != null) {
                return response.tasks().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAuditMitigationActionsTasksResponseFetcher
    implements SyncPageFetcher<ListAuditMitigationActionsTasksResponse> {
        private ListAuditMitigationActionsTasksResponseFetcher() {
        }

        public boolean hasNextPage(ListAuditMitigationActionsTasksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAuditMitigationActionsTasksResponse nextPage(ListAuditMitigationActionsTasksResponse previousPage) {
            if (previousPage == null) {
                return ListAuditMitigationActionsTasksIterable.this.client.listAuditMitigationActionsTasks(ListAuditMitigationActionsTasksIterable.this.firstRequest);
            }
            return ListAuditMitigationActionsTasksIterable.this.client.listAuditMitigationActionsTasks((ListAuditMitigationActionsTasksRequest)((Object)ListAuditMitigationActionsTasksIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

