/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.IotResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetPackageResponse
extends IotResponse
implements ToCopyableBuilder<Builder, GetPackageResponse> {
    private static final SdkField<String> PACKAGE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("packageName").getter(GetPackageResponse.getter(GetPackageResponse::packageName)).setter(GetPackageResponse.setter(Builder::packageName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("packageName").build()}).build();
    private static final SdkField<String> PACKAGE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("packageArn").getter(GetPackageResponse.getter(GetPackageResponse::packageArn)).setter(GetPackageResponse.setter(Builder::packageArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("packageArn").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(GetPackageResponse.getter(GetPackageResponse::description)).setter(GetPackageResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> DEFAULT_VERSION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("defaultVersionName").getter(GetPackageResponse.getter(GetPackageResponse::defaultVersionName)).setter(GetPackageResponse.setter(Builder::defaultVersionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultVersionName").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationDate").getter(GetPackageResponse.getter(GetPackageResponse::creationDate)).setter(GetPackageResponse.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDate").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastModifiedDate").getter(GetPackageResponse.getter(GetPackageResponse::lastModifiedDate)).setter(GetPackageResponse.setter(Builder::lastModifiedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PACKAGE_NAME_FIELD, PACKAGE_ARN_FIELD, DESCRIPTION_FIELD, DEFAULT_VERSION_NAME_FIELD, CREATION_DATE_FIELD, LAST_MODIFIED_DATE_FIELD));
    private final String packageName;
    private final String packageArn;
    private final String description;
    private final String defaultVersionName;
    private final Instant creationDate;
    private final Instant lastModifiedDate;

    private GetPackageResponse(BuilderImpl builder) {
        super(builder);
        this.packageName = builder.packageName;
        this.packageArn = builder.packageArn;
        this.description = builder.description;
        this.defaultVersionName = builder.defaultVersionName;
        this.creationDate = builder.creationDate;
        this.lastModifiedDate = builder.lastModifiedDate;
    }

    public final String packageName() {
        return this.packageName;
    }

    public final String packageArn() {
        return this.packageArn;
    }

    public final String description() {
        return this.description;
    }

    public final String defaultVersionName() {
        return this.defaultVersionName;
    }

    public final Instant creationDate() {
        return this.creationDate;
    }

    public final Instant lastModifiedDate() {
        return this.lastModifiedDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.packageName());
        hashCode = 31 * hashCode + Objects.hashCode(this.packageArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultVersionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedDate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPackageResponse)) {
            return false;
        }
        GetPackageResponse other = (GetPackageResponse)((Object)obj);
        return Objects.equals(this.packageName(), other.packageName()) && Objects.equals(this.packageArn(), other.packageArn()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.defaultVersionName(), other.defaultVersionName()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.lastModifiedDate(), other.lastModifiedDate());
    }

    public final String toString() {
        return ToString.builder((String)"GetPackageResponse").add("PackageName", (Object)this.packageName()).add("PackageArn", (Object)this.packageArn()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("DefaultVersionName", (Object)this.defaultVersionName()).add("CreationDate", (Object)this.creationDate()).add("LastModifiedDate", (Object)this.lastModifiedDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "packageName": {
                return Optional.ofNullable(clazz.cast(this.packageName()));
            }
            case "packageArn": {
                return Optional.ofNullable(clazz.cast(this.packageArn()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "defaultVersionName": {
                return Optional.ofNullable(clazz.cast(this.defaultVersionName()));
            }
            case "creationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "lastModifiedDate": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedDate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetPackageResponse, T> g) {
        return obj -> g.apply((GetPackageResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotResponse.BuilderImpl
    implements Builder {
        private String packageName;
        private String packageArn;
        private String description;
        private String defaultVersionName;
        private Instant creationDate;
        private Instant lastModifiedDate;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPackageResponse model) {
            super(model);
            this.packageName(model.packageName);
            this.packageArn(model.packageArn);
            this.description(model.description);
            this.defaultVersionName(model.defaultVersionName);
            this.creationDate(model.creationDate);
            this.lastModifiedDate(model.lastModifiedDate);
        }

        public final String getPackageName() {
            return this.packageName;
        }

        public final void setPackageName(String packageName) {
            this.packageName = packageName;
        }

        @Override
        public final Builder packageName(String packageName) {
            this.packageName = packageName;
            return this;
        }

        public final String getPackageArn() {
            return this.packageArn;
        }

        public final void setPackageArn(String packageArn) {
            this.packageArn = packageArn;
        }

        @Override
        public final Builder packageArn(String packageArn) {
            this.packageArn = packageArn;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDefaultVersionName() {
            return this.defaultVersionName;
        }

        public final void setDefaultVersionName(String defaultVersionName) {
            this.defaultVersionName = defaultVersionName;
        }

        @Override
        public final Builder defaultVersionName(String defaultVersionName) {
            this.defaultVersionName = defaultVersionName;
            return this;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final Instant getLastModifiedDate() {
            return this.lastModifiedDate;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        @Override
        public GetPackageResponse build() {
            return new GetPackageResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetPackageResponse> {
        public Builder packageName(String var1);

        public Builder packageArn(String var1);

        public Builder description(String var1);

        public Builder defaultVersionName(String var1);

        public Builder creationDate(Instant var1);

        public Builder lastModifiedDate(Instant var1);
    }
}

