/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iot.IotAsyncClient;
import software.amazon.awssdk.services.iot.internal.UserAgentUtils;
import software.amazon.awssdk.services.iot.model.ListMetricValuesRequest;
import software.amazon.awssdk.services.iot.model.ListMetricValuesResponse;
import software.amazon.awssdk.services.iot.model.MetricDatum;

public class ListMetricValuesPublisher
implements SdkPublisher<ListMetricValuesResponse> {
    private final IotAsyncClient client;
    private final ListMetricValuesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListMetricValuesPublisher(IotAsyncClient client, ListMetricValuesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListMetricValuesPublisher(IotAsyncClient client, ListMetricValuesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListMetricValuesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListMetricValuesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<MetricDatum> metricDatumList() {
        Function<ListMetricValuesResponse, Iterator> getIterator = response -> {
            if (response != null && response.metricDatumList() != null) {
                return response.metricDatumList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListMetricValuesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListMetricValuesResponseFetcher
    implements AsyncPageFetcher<ListMetricValuesResponse> {
        private ListMetricValuesResponseFetcher() {
        }

        public boolean hasNextPage(ListMetricValuesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListMetricValuesResponse> nextPage(ListMetricValuesResponse previousPage) {
            if (previousPage == null) {
                return ListMetricValuesPublisher.this.client.listMetricValues(ListMetricValuesPublisher.this.firstRequest);
            }
            return ListMetricValuesPublisher.this.client.listMetricValues((ListMetricValuesRequest)((Object)ListMetricValuesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

