/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An OTA update summary.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OTAUpdateSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<OTAUpdateSummary.Builder, OTAUpdateSummary> {
    private static final SdkField<String> OTA_UPDATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("otaUpdateId").getter(getter(OTAUpdateSummary::otaUpdateId)).setter(setter(Builder::otaUpdateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("otaUpdateId").build()).build();

    private static final SdkField<String> OTA_UPDATE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("otaUpdateArn").getter(getter(OTAUpdateSummary::otaUpdateArn)).setter(setter(Builder::otaUpdateArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("otaUpdateArn").build()).build();

    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationDate").getter(getter(OTAUpdateSummary::creationDate)).setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OTA_UPDATE_ID_FIELD,
            OTA_UPDATE_ARN_FIELD, CREATION_DATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String otaUpdateId;

    private final String otaUpdateArn;

    private final Instant creationDate;

    private OTAUpdateSummary(BuilderImpl builder) {
        this.otaUpdateId = builder.otaUpdateId;
        this.otaUpdateArn = builder.otaUpdateArn;
        this.creationDate = builder.creationDate;
    }

    /**
     * <p>
     * The OTA update ID.
     * </p>
     * 
     * @return The OTA update ID.
     */
    public final String otaUpdateId() {
        return otaUpdateId;
    }

    /**
     * <p>
     * The OTA update ARN.
     * </p>
     * 
     * @return The OTA update ARN.
     */
    public final String otaUpdateArn() {
        return otaUpdateArn;
    }

    /**
     * <p>
     * The date when the OTA update was created.
     * </p>
     * 
     * @return The date when the OTA update was created.
     */
    public final Instant creationDate() {
        return creationDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(otaUpdateId());
        hashCode = 31 * hashCode + Objects.hashCode(otaUpdateArn());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OTAUpdateSummary)) {
            return false;
        }
        OTAUpdateSummary other = (OTAUpdateSummary) obj;
        return Objects.equals(otaUpdateId(), other.otaUpdateId()) && Objects.equals(otaUpdateArn(), other.otaUpdateArn())
                && Objects.equals(creationDate(), other.creationDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OTAUpdateSummary").add("OtaUpdateId", otaUpdateId()).add("OtaUpdateArn", otaUpdateArn())
                .add("CreationDate", creationDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "otaUpdateId":
            return Optional.ofNullable(clazz.cast(otaUpdateId()));
        case "otaUpdateArn":
            return Optional.ofNullable(clazz.cast(otaUpdateArn()));
        case "creationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OTAUpdateSummary, T> g) {
        return obj -> g.apply((OTAUpdateSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OTAUpdateSummary> {
        /**
         * <p>
         * The OTA update ID.
         * </p>
         * 
         * @param otaUpdateId
         *        The OTA update ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder otaUpdateId(String otaUpdateId);

        /**
         * <p>
         * The OTA update ARN.
         * </p>
         * 
         * @param otaUpdateArn
         *        The OTA update ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder otaUpdateArn(String otaUpdateArn);

        /**
         * <p>
         * The date when the OTA update was created.
         * </p>
         * 
         * @param creationDate
         *        The date when the OTA update was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);
    }

    static final class BuilderImpl implements Builder {
        private String otaUpdateId;

        private String otaUpdateArn;

        private Instant creationDate;

        private BuilderImpl() {
        }

        private BuilderImpl(OTAUpdateSummary model) {
            otaUpdateId(model.otaUpdateId);
            otaUpdateArn(model.otaUpdateArn);
            creationDate(model.creationDate);
        }

        public final String getOtaUpdateId() {
            return otaUpdateId;
        }

        public final void setOtaUpdateId(String otaUpdateId) {
            this.otaUpdateId = otaUpdateId;
        }

        @Override
        public final Builder otaUpdateId(String otaUpdateId) {
            this.otaUpdateId = otaUpdateId;
            return this;
        }

        public final String getOtaUpdateArn() {
            return otaUpdateArn;
        }

        public final void setOtaUpdateArn(String otaUpdateArn) {
            this.otaUpdateArn = otaUpdateArn;
        }

        @Override
        public final Builder otaUpdateArn(String otaUpdateArn) {
            this.otaUpdateArn = otaUpdateArn;
            return this;
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        @Override
        public OTAUpdateSummary build() {
            return new OTAUpdateSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
