/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides additional filters for specific data sources. Named shadow is the only data source that currently supports
 * and requires a filter. To add named shadows to your fleet indexing configuration, set
 * <code>namedShadowIndexingMode</code> to be <code>ON</code> and specify your shadow names in <code>filter</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IndexingFilter implements SdkPojo, Serializable, ToCopyableBuilder<IndexingFilter.Builder, IndexingFilter> {
    private static final SdkField<List<String>> NAMED_SHADOW_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("namedShadowNames")
            .getter(getter(IndexingFilter::namedShadowNames))
            .setter(setter(Builder::namedShadowNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namedShadowNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAMED_SHADOW_NAMES_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> namedShadowNames;

    private IndexingFilter(BuilderImpl builder) {
        this.namedShadowNames = builder.namedShadowNames;
    }

    /**
     * For responses, this returns true if the service returned a value for the NamedShadowNames property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasNamedShadowNames() {
        return namedShadowNames != null && !(namedShadowNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The shadow names that you select to index. The default maximum number of shadow names for indexing is 10. To
     * increase the limit, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/iot_device_management.html#fleet-indexing-limits">Amazon Web
     * Services IoT Device Management Quotas</a> in the <i>Amazon Web Services General Reference</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNamedShadowNames} method.
     * </p>
     * 
     * @return The shadow names that you select to index. The default maximum number of shadow names for indexing is 10.
     *         To increase the limit, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/iot_device_management.html#fleet-indexing-limits"
     *         >Amazon Web Services IoT Device Management Quotas</a> in the <i>Amazon Web Services General
     *         Reference</i>.
     */
    public final List<String> namedShadowNames() {
        return namedShadowNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasNamedShadowNames() ? namedShadowNames() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IndexingFilter)) {
            return false;
        }
        IndexingFilter other = (IndexingFilter) obj;
        return hasNamedShadowNames() == other.hasNamedShadowNames()
                && Objects.equals(namedShadowNames(), other.namedShadowNames());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IndexingFilter").add("NamedShadowNames", hasNamedShadowNames() ? namedShadowNames() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "namedShadowNames":
            return Optional.ofNullable(clazz.cast(namedShadowNames()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IndexingFilter, T> g) {
        return obj -> g.apply((IndexingFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IndexingFilter> {
        /**
         * <p>
         * The shadow names that you select to index. The default maximum number of shadow names for indexing is 10. To
         * increase the limit, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/iot_device_management.html#fleet-indexing-limits">Amazon
         * Web Services IoT Device Management Quotas</a> in the <i>Amazon Web Services General Reference</i>.
         * </p>
         * 
         * @param namedShadowNames
         *        The shadow names that you select to index. The default maximum number of shadow names for indexing is
         *        10. To increase the limit, see <a href=
         *        "https://docs.aws.amazon.com/general/latest/gr/iot_device_management.html#fleet-indexing-limits"
         *        >Amazon Web Services IoT Device Management Quotas</a> in the <i>Amazon Web Services General
         *        Reference</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namedShadowNames(Collection<String> namedShadowNames);

        /**
         * <p>
         * The shadow names that you select to index. The default maximum number of shadow names for indexing is 10. To
         * increase the limit, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/iot_device_management.html#fleet-indexing-limits">Amazon
         * Web Services IoT Device Management Quotas</a> in the <i>Amazon Web Services General Reference</i>.
         * </p>
         * 
         * @param namedShadowNames
         *        The shadow names that you select to index. The default maximum number of shadow names for indexing is
         *        10. To increase the limit, see <a href=
         *        "https://docs.aws.amazon.com/general/latest/gr/iot_device_management.html#fleet-indexing-limits"
         *        >Amazon Web Services IoT Device Management Quotas</a> in the <i>Amazon Web Services General
         *        Reference</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namedShadowNames(String... namedShadowNames);
    }

    static final class BuilderImpl implements Builder {
        private List<String> namedShadowNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(IndexingFilter model) {
            namedShadowNames(model.namedShadowNames);
        }

        public final Collection<String> getNamedShadowNames() {
            if (namedShadowNames instanceof SdkAutoConstructList) {
                return null;
            }
            return namedShadowNames;
        }

        public final void setNamedShadowNames(Collection<String> namedShadowNames) {
            this.namedShadowNames = NamedShadowNamesFilterCopier.copy(namedShadowNames);
        }

        @Override
        public final Builder namedShadowNames(Collection<String> namedShadowNames) {
            this.namedShadowNames = NamedShadowNamesFilterCopier.copy(namedShadowNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder namedShadowNames(String... namedShadowNames) {
            namedShadowNames(Arrays.asList(namedShadowNames));
            return this;
        }

        @Override
        public IndexingFilter build() {
            return new IndexingFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
