/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iot.IotClient;
import software.amazon.awssdk.services.iot.model.BehaviorModelTrainingSummary;
import software.amazon.awssdk.services.iot.model.GetBehaviorModelTrainingSummariesRequest;
import software.amazon.awssdk.services.iot.model.GetBehaviorModelTrainingSummariesResponse;

public class GetBehaviorModelTrainingSummariesIterable
implements SdkIterable<GetBehaviorModelTrainingSummariesResponse> {
    private final IotClient client;
    private final GetBehaviorModelTrainingSummariesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetBehaviorModelTrainingSummariesIterable(IotClient client, GetBehaviorModelTrainingSummariesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetBehaviorModelTrainingSummariesResponseFetcher();
    }

    public Iterator<GetBehaviorModelTrainingSummariesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<BehaviorModelTrainingSummary> summaries() {
        Function<GetBehaviorModelTrainingSummariesResponse, Iterator> getIterator = response -> {
            if (response != null && response.summaries() != null) {
                return response.summaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetBehaviorModelTrainingSummariesResponseFetcher
    implements SyncPageFetcher<GetBehaviorModelTrainingSummariesResponse> {
        private GetBehaviorModelTrainingSummariesResponseFetcher() {
        }

        public boolean hasNextPage(GetBehaviorModelTrainingSummariesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetBehaviorModelTrainingSummariesResponse nextPage(GetBehaviorModelTrainingSummariesResponse previousPage) {
            if (previousPage == null) {
                return GetBehaviorModelTrainingSummariesIterable.this.client.getBehaviorModelTrainingSummaries(GetBehaviorModelTrainingSummariesIterable.this.firstRequest);
            }
            return GetBehaviorModelTrainingSummariesIterable.this.client.getBehaviorModelTrainingSummaries((GetBehaviorModelTrainingSummariesRequest)((Object)GetBehaviorModelTrainingSummariesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

