/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IotAnalyticsAction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IotAnalyticsAction> {
    private static final SdkField<String> CHANNEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("channelArn").getter(IotAnalyticsAction.getter(IotAnalyticsAction::channelArn)).setter(IotAnalyticsAction.setter(Builder::channelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelArn").build()}).build();
    private static final SdkField<String> CHANNEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("channelName").getter(IotAnalyticsAction.getter(IotAnalyticsAction::channelName)).setter(IotAnalyticsAction.setter(Builder::channelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelName").build()}).build();
    private static final SdkField<Boolean> BATCH_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("batchMode").getter(IotAnalyticsAction.getter(IotAnalyticsAction::batchMode)).setter(IotAnalyticsAction.setter(Builder::batchMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("batchMode").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(IotAnalyticsAction.getter(IotAnalyticsAction::roleArn)).setter(IotAnalyticsAction.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_ARN_FIELD, CHANNEL_NAME_FIELD, BATCH_MODE_FIELD, ROLE_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String channelArn;
    private final String channelName;
    private final Boolean batchMode;
    private final String roleArn;

    private IotAnalyticsAction(BuilderImpl builder) {
        this.channelArn = builder.channelArn;
        this.channelName = builder.channelName;
        this.batchMode = builder.batchMode;
        this.roleArn = builder.roleArn;
    }

    public final String channelArn() {
        return this.channelArn;
    }

    public final String channelName() {
        return this.channelName;
    }

    public final Boolean batchMode() {
        return this.batchMode;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.channelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.channelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.batchMode());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IotAnalyticsAction)) {
            return false;
        }
        IotAnalyticsAction other = (IotAnalyticsAction)obj;
        return Objects.equals(this.channelArn(), other.channelArn()) && Objects.equals(this.channelName(), other.channelName()) && Objects.equals(this.batchMode(), other.batchMode()) && Objects.equals(this.roleArn(), other.roleArn());
    }

    public final String toString() {
        return ToString.builder((String)"IotAnalyticsAction").add("ChannelArn", (Object)this.channelArn()).add("ChannelName", (Object)this.channelName()).add("BatchMode", (Object)this.batchMode()).add("RoleArn", (Object)this.roleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "channelArn": {
                return Optional.ofNullable(clazz.cast(this.channelArn()));
            }
            case "channelName": {
                return Optional.ofNullable(clazz.cast(this.channelName()));
            }
            case "batchMode": {
                return Optional.ofNullable(clazz.cast(this.batchMode()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IotAnalyticsAction, T> g) {
        return obj -> g.apply((IotAnalyticsAction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String channelArn;
        private String channelName;
        private Boolean batchMode;
        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(IotAnalyticsAction model) {
            this.channelArn(model.channelArn);
            this.channelName(model.channelName);
            this.batchMode(model.batchMode);
            this.roleArn(model.roleArn);
        }

        public final String getChannelArn() {
            return this.channelArn;
        }

        public final void setChannelArn(String channelArn) {
            this.channelArn = channelArn;
        }

        @Override
        public final Builder channelArn(String channelArn) {
            this.channelArn = channelArn;
            return this;
        }

        public final String getChannelName() {
            return this.channelName;
        }

        public final void setChannelName(String channelName) {
            this.channelName = channelName;
        }

        @Override
        public final Builder channelName(String channelName) {
            this.channelName = channelName;
            return this;
        }

        public final Boolean getBatchMode() {
            return this.batchMode;
        }

        public final void setBatchMode(Boolean batchMode) {
            this.batchMode = batchMode;
        }

        @Override
        public final Builder batchMode(Boolean batchMode) {
            this.batchMode = batchMode;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public IotAnalyticsAction build() {
            return new IotAnalyticsAction(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IotAnalyticsAction> {
        public Builder channelArn(String var1);

        public Builder channelName(String var1);

        public Builder batchMode(Boolean var1);

        public Builder roleArn(String var1);
    }
}

