/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum JobEndBehavior {
    STOP_ROLLOUT("STOP_ROLLOUT"),
    CANCEL("CANCEL"),
    FORCE_CANCEL("FORCE_CANCEL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, JobEndBehavior> VALUE_MAP;
    private final String value;

    private JobEndBehavior(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static JobEndBehavior fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<JobEndBehavior> knownValues() {
        EnumSet<JobEndBehavior> knownValues = EnumSet.allOf(JobEndBehavior.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(JobEndBehavior.class, JobEndBehavior::toString);
    }
}

