/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ComparisonOperator {
    LESS_THAN("less-than"),
    LESS_THAN_EQUALS("less-than-equals"),
    GREATER_THAN("greater-than"),
    GREATER_THAN_EQUALS("greater-than-equals"),
    IN_CIDR_SET("in-cidr-set"),
    NOT_IN_CIDR_SET("not-in-cidr-set"),
    IN_PORT_SET("in-port-set"),
    NOT_IN_PORT_SET("not-in-port-set"),
    IN_SET("in-set"),
    NOT_IN_SET("not-in-set"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ComparisonOperator> VALUE_MAP;
    private final String value;

    private ComparisonOperator(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ComparisonOperator fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ComparisonOperator> knownValues() {
        EnumSet<ComparisonOperator> knownValues = EnumSet.allOf(ComparisonOperator.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ComparisonOperator.class, ComparisonOperator::toString);
    }
}

