/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.AuditMitigationActionsExecutionStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AuditMitigationActionExecutionMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AuditMitigationActionExecutionMetadata> {
    private static final SdkField<String> TASK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("taskId").getter(AuditMitigationActionExecutionMetadata.getter(AuditMitigationActionExecutionMetadata::taskId)).setter(AuditMitigationActionExecutionMetadata.setter(Builder::taskId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskId").build()}).build();
    private static final SdkField<String> FINDING_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("findingId").getter(AuditMitigationActionExecutionMetadata.getter(AuditMitigationActionExecutionMetadata::findingId)).setter(AuditMitigationActionExecutionMetadata.setter(Builder::findingId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findingId").build()}).build();
    private static final SdkField<String> ACTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("actionName").getter(AuditMitigationActionExecutionMetadata.getter(AuditMitigationActionExecutionMetadata::actionName)).setter(AuditMitigationActionExecutionMetadata.setter(Builder::actionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionName").build()}).build();
    private static final SdkField<String> ACTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("actionId").getter(AuditMitigationActionExecutionMetadata.getter(AuditMitigationActionExecutionMetadata::actionId)).setter(AuditMitigationActionExecutionMetadata.setter(Builder::actionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(AuditMitigationActionExecutionMetadata.getter(AuditMitigationActionExecutionMetadata::statusAsString)).setter(AuditMitigationActionExecutionMetadata.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startTime").getter(AuditMitigationActionExecutionMetadata.getter(AuditMitigationActionExecutionMetadata::startTime)).setter(AuditMitigationActionExecutionMetadata.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endTime").getter(AuditMitigationActionExecutionMetadata.getter(AuditMitigationActionExecutionMetadata::endTime)).setter(AuditMitigationActionExecutionMetadata.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()}).build();
    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("errorCode").getter(AuditMitigationActionExecutionMetadata.getter(AuditMitigationActionExecutionMetadata::errorCode)).setter(AuditMitigationActionExecutionMetadata.setter(Builder::errorCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorCode").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("message").getter(AuditMitigationActionExecutionMetadata.getter(AuditMitigationActionExecutionMetadata::message)).setter(AuditMitigationActionExecutionMetadata.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_ID_FIELD, FINDING_ID_FIELD, ACTION_NAME_FIELD, ACTION_ID_FIELD, STATUS_FIELD, START_TIME_FIELD, END_TIME_FIELD, ERROR_CODE_FIELD, MESSAGE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String taskId;
    private final String findingId;
    private final String actionName;
    private final String actionId;
    private final String status;
    private final Instant startTime;
    private final Instant endTime;
    private final String errorCode;
    private final String message;

    private AuditMitigationActionExecutionMetadata(BuilderImpl builder) {
        this.taskId = builder.taskId;
        this.findingId = builder.findingId;
        this.actionName = builder.actionName;
        this.actionId = builder.actionId;
        this.status = builder.status;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.errorCode = builder.errorCode;
        this.message = builder.message;
    }

    public final String taskId() {
        return this.taskId;
    }

    public final String findingId() {
        return this.findingId;
    }

    public final String actionName() {
        return this.actionName;
    }

    public final String actionId() {
        return this.actionId;
    }

    public final AuditMitigationActionsExecutionStatus status() {
        return AuditMitigationActionsExecutionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final String errorCode() {
        return this.errorCode;
    }

    public final String message() {
        return this.message;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.taskId());
        hashCode = 31 * hashCode + Objects.hashCode(this.findingId());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuditMitigationActionExecutionMetadata)) {
            return false;
        }
        AuditMitigationActionExecutionMetadata other = (AuditMitigationActionExecutionMetadata)obj;
        return Objects.equals(this.taskId(), other.taskId()) && Objects.equals(this.findingId(), other.findingId()) && Objects.equals(this.actionName(), other.actionName()) && Objects.equals(this.actionId(), other.actionId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.errorCode(), other.errorCode()) && Objects.equals(this.message(), other.message());
    }

    public final String toString() {
        return ToString.builder((String)"AuditMitigationActionExecutionMetadata").add("TaskId", (Object)this.taskId()).add("FindingId", (Object)this.findingId()).add("ActionName", (Object)this.actionName()).add("ActionId", (Object)this.actionId()).add("Status", (Object)this.statusAsString()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("ErrorCode", (Object)this.errorCode()).add("Message", (Object)this.message()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "taskId": {
                return Optional.ofNullable(clazz.cast(this.taskId()));
            }
            case "findingId": {
                return Optional.ofNullable(clazz.cast(this.findingId()));
            }
            case "actionName": {
                return Optional.ofNullable(clazz.cast(this.actionName()));
            }
            case "actionId": {
                return Optional.ofNullable(clazz.cast(this.actionId()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "endTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "errorCode": {
                return Optional.ofNullable(clazz.cast(this.errorCode()));
            }
            case "message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AuditMitigationActionExecutionMetadata, T> g) {
        return obj -> g.apply((AuditMitigationActionExecutionMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String taskId;
        private String findingId;
        private String actionName;
        private String actionId;
        private String status;
        private Instant startTime;
        private Instant endTime;
        private String errorCode;
        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(AuditMitigationActionExecutionMetadata model) {
            this.taskId(model.taskId);
            this.findingId(model.findingId);
            this.actionName(model.actionName);
            this.actionId(model.actionId);
            this.status(model.status);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.errorCode(model.errorCode);
            this.message(model.message);
        }

        public final String getTaskId() {
            return this.taskId;
        }

        public final void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        @Override
        public final Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public final String getFindingId() {
            return this.findingId;
        }

        public final void setFindingId(String findingId) {
            this.findingId = findingId;
        }

        @Override
        public final Builder findingId(String findingId) {
            this.findingId = findingId;
            return this;
        }

        public final String getActionName() {
            return this.actionName;
        }

        public final void setActionName(String actionName) {
            this.actionName = actionName;
        }

        @Override
        public final Builder actionName(String actionName) {
            this.actionName = actionName;
            return this;
        }

        public final String getActionId() {
            return this.actionId;
        }

        public final void setActionId(String actionId) {
            this.actionId = actionId;
        }

        @Override
        public final Builder actionId(String actionId) {
            this.actionId = actionId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AuditMitigationActionsExecutionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getErrorCode() {
            return this.errorCode;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public final String getMessage() {
            return this.message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public AuditMitigationActionExecutionMetadata build() {
            return new AuditMitigationActionExecutionMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AuditMitigationActionExecutionMetadata> {
        public Builder taskId(String var1);

        public Builder findingId(String var1);

        public Builder actionName(String var1);

        public Builder actionId(String var1);

        public Builder status(String var1);

        public Builder status(AuditMitigationActionsExecutionStatus var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder errorCode(String var1);

        public Builder message(String var1);
    }
}

