/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class TestAuthorizationResponse extends IotResponse implements
        ToCopyableBuilder<TestAuthorizationResponse.Builder, TestAuthorizationResponse> {
    private static final SdkField<List<AuthResult>> AUTH_RESULTS_FIELD = SdkField
            .<List<AuthResult>> builder(MarshallingType.LIST)
            .memberName("authResults")
            .getter(getter(TestAuthorizationResponse::authResults))
            .setter(setter(Builder::authResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authResults").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AuthResult> builder(MarshallingType.SDK_POJO)
                                            .constructor(AuthResult::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTH_RESULTS_FIELD));

    private final List<AuthResult> authResults;

    private TestAuthorizationResponse(BuilderImpl builder) {
        super(builder);
        this.authResults = builder.authResults;
    }

    /**
     * For responses, this returns true if the service returned a value for the AuthResults property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAuthResults() {
        return authResults != null && !(authResults instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The authentication results.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAuthResults} method.
     * </p>
     * 
     * @return The authentication results.
     */
    public final List<AuthResult> authResults() {
        return authResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAuthResults() ? authResults() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestAuthorizationResponse)) {
            return false;
        }
        TestAuthorizationResponse other = (TestAuthorizationResponse) obj;
        return hasAuthResults() == other.hasAuthResults() && Objects.equals(authResults(), other.authResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TestAuthorizationResponse").add("AuthResults", hasAuthResults() ? authResults() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "authResults":
            return Optional.ofNullable(clazz.cast(authResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TestAuthorizationResponse, T> g) {
        return obj -> g.apply((TestAuthorizationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotResponse.Builder, SdkPojo, CopyableBuilder<Builder, TestAuthorizationResponse> {
        /**
         * <p>
         * The authentication results.
         * </p>
         * 
         * @param authResults
         *        The authentication results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authResults(Collection<AuthResult> authResults);

        /**
         * <p>
         * The authentication results.
         * </p>
         * 
         * @param authResults
         *        The authentication results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authResults(AuthResult... authResults);

        /**
         * <p>
         * The authentication results.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iot.model.AuthResult.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.iot.model.AuthResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iot.model.AuthResult.Builder#build()} is called immediately and its
         * result is passed to {@link #authResults(List<AuthResult>)}.
         * 
         * @param authResults
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iot.model.AuthResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #authResults(java.util.Collection<AuthResult>)
         */
        Builder authResults(Consumer<AuthResult.Builder>... authResults);
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private List<AuthResult> authResults = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TestAuthorizationResponse model) {
            super(model);
            authResults(model.authResults);
        }

        public final List<AuthResult.Builder> getAuthResults() {
            List<AuthResult.Builder> result = AuthResultsCopier.copyToBuilder(this.authResults);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAuthResults(Collection<AuthResult.BuilderImpl> authResults) {
            this.authResults = AuthResultsCopier.copyFromBuilder(authResults);
        }

        @Override
        public final Builder authResults(Collection<AuthResult> authResults) {
            this.authResults = AuthResultsCopier.copy(authResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authResults(AuthResult... authResults) {
            authResults(Arrays.asList(authResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authResults(Consumer<AuthResult.Builder>... authResults) {
            authResults(Stream.of(authResults).map(c -> AuthResult.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public TestAuthorizationResponse build() {
            return new TestAuthorizationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
