/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociateTargetsWithJobRequest extends IotRequest implements
        ToCopyableBuilder<AssociateTargetsWithJobRequest.Builder, AssociateTargetsWithJobRequest> {
    private static final SdkField<List<String>> TARGETS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("targets")
            .getter(getter(AssociateTargetsWithJobRequest::targets))
            .setter(setter(Builder::targets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("jobId")
            .getter(getter(AssociateTargetsWithJobRequest::jobId)).setter(setter(Builder::jobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("jobId").build()).build();

    private static final SdkField<String> COMMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("comment")
            .getter(getter(AssociateTargetsWithJobRequest::comment)).setter(setter(Builder::comment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("comment").build()).build();

    private static final SdkField<String> NAMESPACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("namespaceId").getter(getter(AssociateTargetsWithJobRequest::namespaceId))
            .setter(setter(Builder::namespaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("namespaceId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGETS_FIELD, JOB_ID_FIELD,
            COMMENT_FIELD, NAMESPACE_ID_FIELD));

    private final List<String> targets;

    private final String jobId;

    private final String comment;

    private final String namespaceId;

    private AssociateTargetsWithJobRequest(BuilderImpl builder) {
        super(builder);
        this.targets = builder.targets;
        this.jobId = builder.jobId;
        this.comment = builder.comment;
        this.namespaceId = builder.namespaceId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Targets property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTargets() {
        return targets != null && !(targets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of thing group ARNs that define the targets of the job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTargets} method.
     * </p>
     * 
     * @return A list of thing group ARNs that define the targets of the job.
     */
    public final List<String> targets() {
        return targets;
    }

    /**
     * <p>
     * The unique identifier you assigned to this job when it was created.
     * </p>
     * 
     * @return The unique identifier you assigned to this job when it was created.
     */
    public final String jobId() {
        return jobId;
    }

    /**
     * <p>
     * An optional comment string describing why the job was associated with the targets.
     * </p>
     * 
     * @return An optional comment string describing why the job was associated with the targets.
     */
    public final String comment() {
        return comment;
    }

    /**
     * <p>
     * The namespace used to indicate that a job is a customer-managed job.
     * </p>
     * <p>
     * When you specify a value for this parameter, Amazon Web Services IoT Core sends jobs notifications to MQTT topics
     * that contain the value in the following format.
     * </p>
     * <p>
     * <code>$aws/things/<i>THING_NAME</i>/jobs/<i>JOB_ID</i>/notify-namespace-<i>NAMESPACE_ID</i>/</code>
     * </p>
     * <note>
     * <p>
     * The <code>namespaceId</code> feature is in public preview.
     * </p>
     * </note>
     * 
     * @return The namespace used to indicate that a job is a customer-managed job.</p>
     *         <p>
     *         When you specify a value for this parameter, Amazon Web Services IoT Core sends jobs notifications to
     *         MQTT topics that contain the value in the following format.
     *         </p>
     *         <p>
     *         <code>$aws/things/<i>THING_NAME</i>/jobs/<i>JOB_ID</i>/notify-namespace-<i>NAMESPACE_ID</i>/</code>
     *         </p>
     *         <note>
     *         <p>
     *         The <code>namespaceId</code> feature is in public preview.
     *         </p>
     */
    public final String namespaceId() {
        return namespaceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasTargets() ? targets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(comment());
        hashCode = 31 * hashCode + Objects.hashCode(namespaceId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateTargetsWithJobRequest)) {
            return false;
        }
        AssociateTargetsWithJobRequest other = (AssociateTargetsWithJobRequest) obj;
        return hasTargets() == other.hasTargets() && Objects.equals(targets(), other.targets())
                && Objects.equals(jobId(), other.jobId()) && Objects.equals(comment(), other.comment())
                && Objects.equals(namespaceId(), other.namespaceId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociateTargetsWithJobRequest").add("Targets", hasTargets() ? targets() : null)
                .add("JobId", jobId()).add("Comment", comment()).add("NamespaceId", namespaceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "targets":
            return Optional.ofNullable(clazz.cast(targets()));
        case "jobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "comment":
            return Optional.ofNullable(clazz.cast(comment()));
        case "namespaceId":
            return Optional.ofNullable(clazz.cast(namespaceId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociateTargetsWithJobRequest, T> g) {
        return obj -> g.apply((AssociateTargetsWithJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotRequest.Builder, SdkPojo, CopyableBuilder<Builder, AssociateTargetsWithJobRequest> {
        /**
         * <p>
         * A list of thing group ARNs that define the targets of the job.
         * </p>
         * 
         * @param targets
         *        A list of thing group ARNs that define the targets of the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targets(Collection<String> targets);

        /**
         * <p>
         * A list of thing group ARNs that define the targets of the job.
         * </p>
         * 
         * @param targets
         *        A list of thing group ARNs that define the targets of the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targets(String... targets);

        /**
         * <p>
         * The unique identifier you assigned to this job when it was created.
         * </p>
         * 
         * @param jobId
         *        The unique identifier you assigned to this job when it was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * An optional comment string describing why the job was associated with the targets.
         * </p>
         * 
         * @param comment
         *        An optional comment string describing why the job was associated with the targets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comment(String comment);

        /**
         * <p>
         * The namespace used to indicate that a job is a customer-managed job.
         * </p>
         * <p>
         * When you specify a value for this parameter, Amazon Web Services IoT Core sends jobs notifications to MQTT
         * topics that contain the value in the following format.
         * </p>
         * <p>
         * <code>$aws/things/<i>THING_NAME</i>/jobs/<i>JOB_ID</i>/notify-namespace-<i>NAMESPACE_ID</i>/</code>
         * </p>
         * <note>
         * <p>
         * The <code>namespaceId</code> feature is in public preview.
         * </p>
         * </note>
         * 
         * @param namespaceId
         *        The namespace used to indicate that a job is a customer-managed job.</p>
         *        <p>
         *        When you specify a value for this parameter, Amazon Web Services IoT Core sends jobs notifications to
         *        MQTT topics that contain the value in the following format.
         *        </p>
         *        <p>
         *        <code>$aws/things/<i>THING_NAME</i>/jobs/<i>JOB_ID</i>/notify-namespace-<i>NAMESPACE_ID</i>/</code>
         *        </p>
         *        <note>
         *        <p>
         *        The <code>namespaceId</code> feature is in public preview.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespaceId(String namespaceId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private List<String> targets = DefaultSdkAutoConstructList.getInstance();

        private String jobId;

        private String comment;

        private String namespaceId;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateTargetsWithJobRequest model) {
            super(model);
            targets(model.targets);
            jobId(model.jobId);
            comment(model.comment);
            namespaceId(model.namespaceId);
        }

        public final Collection<String> getTargets() {
            if (targets instanceof SdkAutoConstructList) {
                return null;
            }
            return targets;
        }

        public final void setTargets(Collection<String> targets) {
            this.targets = JobTargetsCopier.copy(targets);
        }

        @Override
        public final Builder targets(Collection<String> targets) {
            this.targets = JobTargetsCopier.copy(targets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(String... targets) {
            targets(Arrays.asList(targets));
            return this;
        }

        public final String getJobId() {
            return jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getComment() {
            return comment;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final String getNamespaceId() {
            return namespaceId;
        }

        public final void setNamespaceId(String namespaceId) {
            this.namespaceId = namespaceId;
        }

        @Override
        public final Builder namespaceId(String namespaceId) {
            this.namespaceId = namespaceId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateTargetsWithJobRequest build() {
            return new AssociateTargetsWithJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
