/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ModelStatus {
    PENDING_BUILD("PENDING_BUILD"),
    ACTIVE("ACTIVE"),
    EXPIRED("EXPIRED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ModelStatus> VALUE_MAP;
    private final String value;

    private ModelStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ModelStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ModelStatus> knownValues() {
        EnumSet<ModelStatus> knownValues = EnumSet.allOf(ModelStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ModelStatus.class, ModelStatus::toString);
    }
}

