/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iot.IotClient;
import software.amazon.awssdk.services.iot.model.ListThingRegistrationTasksRequest;
import software.amazon.awssdk.services.iot.model.ListThingRegistrationTasksResponse;

public class ListThingRegistrationTasksIterable
implements SdkIterable<ListThingRegistrationTasksResponse> {
    private final IotClient client;
    private final ListThingRegistrationTasksRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListThingRegistrationTasksIterable(IotClient client, ListThingRegistrationTasksRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListThingRegistrationTasksResponseFetcher();
    }

    public Iterator<ListThingRegistrationTasksResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<String> taskIds() {
        Function<ListThingRegistrationTasksResponse, Iterator> getIterator = response -> {
            if (response != null && response.taskIds() != null) {
                return response.taskIds().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListThingRegistrationTasksResponseFetcher
    implements SyncPageFetcher<ListThingRegistrationTasksResponse> {
        private ListThingRegistrationTasksResponseFetcher() {
        }

        public boolean hasNextPage(ListThingRegistrationTasksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListThingRegistrationTasksResponse nextPage(ListThingRegistrationTasksResponse previousPage) {
            if (previousPage == null) {
                return ListThingRegistrationTasksIterable.this.client.listThingRegistrationTasks(ListThingRegistrationTasksIterable.this.firstRequest);
            }
            return ListThingRegistrationTasksIterable.this.client.listThingRegistrationTasks((ListThingRegistrationTasksRequest)((Object)ListThingRegistrationTasksIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

