/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details the state of Amazon Inspector for each resource type Amazon Inspector scans.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceState implements SdkPojo, Serializable, ToCopyableBuilder<ResourceState.Builder, ResourceState> {
    private static final SdkField<State> EC2_FIELD = SdkField.<State> builder(MarshallingType.SDK_POJO).memberName("ec2")
            .getter(getter(ResourceState::ec2)).setter(setter(Builder::ec2)).constructor(State::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ec2").build()).build();

    private static final SdkField<State> ECR_FIELD = SdkField.<State> builder(MarshallingType.SDK_POJO).memberName("ecr")
            .getter(getter(ResourceState::ecr)).setter(setter(Builder::ecr)).constructor(State::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ecr").build()).build();

    private static final SdkField<State> LAMBDA_FIELD = SdkField.<State> builder(MarshallingType.SDK_POJO).memberName("lambda")
            .getter(getter(ResourceState::lambda)).setter(setter(Builder::lambda)).constructor(State::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lambda").build()).build();

    private static final SdkField<State> LAMBDA_CODE_FIELD = SdkField.<State> builder(MarshallingType.SDK_POJO)
            .memberName("lambdaCode").getter(getter(ResourceState::lambdaCode)).setter(setter(Builder::lambdaCode))
            .constructor(State::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lambdaCode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EC2_FIELD, ECR_FIELD,
            LAMBDA_FIELD, LAMBDA_CODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final State ec2;

    private final State ecr;

    private final State lambda;

    private final State lambdaCode;

    private ResourceState(BuilderImpl builder) {
        this.ec2 = builder.ec2;
        this.ecr = builder.ecr;
        this.lambda = builder.lambda;
        this.lambdaCode = builder.lambdaCode;
    }

    /**
     * <p>
     * An object detailing the state of Amazon Inspector scanning for Amazon EC2 resources.
     * </p>
     * 
     * @return An object detailing the state of Amazon Inspector scanning for Amazon EC2 resources.
     */
    public final State ec2() {
        return ec2;
    }

    /**
     * <p>
     * An object detailing the state of Amazon Inspector scanning for Amazon ECR resources.
     * </p>
     * 
     * @return An object detailing the state of Amazon Inspector scanning for Amazon ECR resources.
     */
    public final State ecr() {
        return ecr;
    }

    /**
     * Returns the value of the Lambda property for this object.
     * 
     * @return The value of the Lambda property for this object.
     */
    public final State lambda() {
        return lambda;
    }

    /**
     * Returns the value of the LambdaCode property for this object.
     * 
     * @return The value of the LambdaCode property for this object.
     */
    public final State lambdaCode() {
        return lambdaCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ec2());
        hashCode = 31 * hashCode + Objects.hashCode(ecr());
        hashCode = 31 * hashCode + Objects.hashCode(lambda());
        hashCode = 31 * hashCode + Objects.hashCode(lambdaCode());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceState)) {
            return false;
        }
        ResourceState other = (ResourceState) obj;
        return Objects.equals(ec2(), other.ec2()) && Objects.equals(ecr(), other.ecr())
                && Objects.equals(lambda(), other.lambda()) && Objects.equals(lambdaCode(), other.lambdaCode());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResourceState").add("Ec2", ec2()).add("Ecr", ecr()).add("Lambda", lambda())
                .add("LambdaCode", lambdaCode()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ec2":
            return Optional.ofNullable(clazz.cast(ec2()));
        case "ecr":
            return Optional.ofNullable(clazz.cast(ecr()));
        case "lambda":
            return Optional.ofNullable(clazz.cast(lambda()));
        case "lambdaCode":
            return Optional.ofNullable(clazz.cast(lambdaCode()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourceState, T> g) {
        return obj -> g.apply((ResourceState) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceState> {
        /**
         * <p>
         * An object detailing the state of Amazon Inspector scanning for Amazon EC2 resources.
         * </p>
         * 
         * @param ec2
         *        An object detailing the state of Amazon Inspector scanning for Amazon EC2 resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2(State ec2);

        /**
         * <p>
         * An object detailing the state of Amazon Inspector scanning for Amazon EC2 resources.
         * </p>
         * This is a convenience method that creates an instance of the {@link State.Builder} avoiding the need to
         * create one manually via {@link State#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link State.Builder#build()} is called immediately and its result is
         * passed to {@link #ec2(State)}.
         * 
         * @param ec2
         *        a consumer that will call methods on {@link State.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ec2(State)
         */
        default Builder ec2(Consumer<State.Builder> ec2) {
            return ec2(State.builder().applyMutation(ec2).build());
        }

        /**
         * <p>
         * An object detailing the state of Amazon Inspector scanning for Amazon ECR resources.
         * </p>
         * 
         * @param ecr
         *        An object detailing the state of Amazon Inspector scanning for Amazon ECR resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ecr(State ecr);

        /**
         * <p>
         * An object detailing the state of Amazon Inspector scanning for Amazon ECR resources.
         * </p>
         * This is a convenience method that creates an instance of the {@link State.Builder} avoiding the need to
         * create one manually via {@link State#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link State.Builder#build()} is called immediately and its result is
         * passed to {@link #ecr(State)}.
         * 
         * @param ecr
         *        a consumer that will call methods on {@link State.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ecr(State)
         */
        default Builder ecr(Consumer<State.Builder> ecr) {
            return ecr(State.builder().applyMutation(ecr).build());
        }

        /**
         * Sets the value of the Lambda property for this object.
         *
         * @param lambda
         *        The new value for the Lambda property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambda(State lambda);

        /**
         * Sets the value of the Lambda property for this object.
         *
         * This is a convenience method that creates an instance of the {@link State.Builder} avoiding the need to
         * create one manually via {@link State#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link State.Builder#build()} is called immediately and its result is
         * passed to {@link #lambda(State)}.
         * 
         * @param lambda
         *        a consumer that will call methods on {@link State.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lambda(State)
         */
        default Builder lambda(Consumer<State.Builder> lambda) {
            return lambda(State.builder().applyMutation(lambda).build());
        }

        /**
         * Sets the value of the LambdaCode property for this object.
         *
         * @param lambdaCode
         *        The new value for the LambdaCode property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambdaCode(State lambdaCode);

        /**
         * Sets the value of the LambdaCode property for this object.
         *
         * This is a convenience method that creates an instance of the {@link State.Builder} avoiding the need to
         * create one manually via {@link State#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link State.Builder#build()} is called immediately and its result is
         * passed to {@link #lambdaCode(State)}.
         * 
         * @param lambdaCode
         *        a consumer that will call methods on {@link State.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lambdaCode(State)
         */
        default Builder lambdaCode(Consumer<State.Builder> lambdaCode) {
            return lambdaCode(State.builder().applyMutation(lambdaCode).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private State ec2;

        private State ecr;

        private State lambda;

        private State lambdaCode;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceState model) {
            ec2(model.ec2);
            ecr(model.ecr);
            lambda(model.lambda);
            lambdaCode(model.lambdaCode);
        }

        public final State.Builder getEc2() {
            return ec2 != null ? ec2.toBuilder() : null;
        }

        public final void setEc2(State.BuilderImpl ec2) {
            this.ec2 = ec2 != null ? ec2.build() : null;
        }

        @Override
        public final Builder ec2(State ec2) {
            this.ec2 = ec2;
            return this;
        }

        public final State.Builder getEcr() {
            return ecr != null ? ecr.toBuilder() : null;
        }

        public final void setEcr(State.BuilderImpl ecr) {
            this.ecr = ecr != null ? ecr.build() : null;
        }

        @Override
        public final Builder ecr(State ecr) {
            this.ecr = ecr;
            return this;
        }

        public final State.Builder getLambda() {
            return lambda != null ? lambda.toBuilder() : null;
        }

        public final void setLambda(State.BuilderImpl lambda) {
            this.lambda = lambda != null ? lambda.build() : null;
        }

        @Override
        public final Builder lambda(State lambda) {
            this.lambda = lambda;
            return this;
        }

        public final State.Builder getLambdaCode() {
            return lambdaCode != null ? lambdaCode.toBuilder() : null;
        }

        public final void setLambdaCode(State.BuilderImpl lambdaCode) {
            this.lambdaCode = lambdaCode != null ? lambdaCode.build() : null;
        }

        @Override
        public final Builder lambdaCode(State lambdaCode) {
            this.lambdaCode = lambdaCode;
            return this;
        }

        @Override
        public ResourceState build() {
            return new ResourceState(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
