/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AmiSortBy {
    CRITICAL("CRITICAL"),
    HIGH("HIGH"),
    ALL("ALL"),
    AFFECTED_INSTANCES("AFFECTED_INSTANCES"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AmiSortBy> VALUE_MAP;
    private final String value;

    private AmiSortBy(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AmiSortBy fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AmiSortBy> knownValues() {
        EnumSet<AmiSortBy> knownValues = EnumSet.allOf(AmiSortBy.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AmiSortBy.class, AmiSortBy::toString);
    }
}

