/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that contains the counts of aggregated finding per severity.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SeverityCounts implements SdkPojo, Serializable, ToCopyableBuilder<SeverityCounts.Builder, SeverityCounts> {
    private static final SdkField<Long> ALL_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("all")
            .getter(getter(SeverityCounts::all)).setter(setter(Builder::all))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("all").build()).build();

    private static final SdkField<Long> CRITICAL_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("critical")
            .getter(getter(SeverityCounts::critical)).setter(setter(Builder::critical))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("critical").build()).build();

    private static final SdkField<Long> HIGH_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("high")
            .getter(getter(SeverityCounts::high)).setter(setter(Builder::high))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("high").build()).build();

    private static final SdkField<Long> MEDIUM_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("medium")
            .getter(getter(SeverityCounts::medium)).setter(setter(Builder::medium))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("medium").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALL_FIELD, CRITICAL_FIELD,
            HIGH_FIELD, MEDIUM_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long all;

    private final Long critical;

    private final Long high;

    private final Long medium;

    private SeverityCounts(BuilderImpl builder) {
        this.all = builder.all;
        this.critical = builder.critical;
        this.high = builder.high;
        this.medium = builder.medium;
    }

    /**
     * <p>
     * The total count of findings from all severities.
     * </p>
     * 
     * @return The total count of findings from all severities.
     */
    public final Long all() {
        return all;
    }

    /**
     * <p>
     * The total count of critical severity findings.
     * </p>
     * 
     * @return The total count of critical severity findings.
     */
    public final Long critical() {
        return critical;
    }

    /**
     * <p>
     * The total count of high severity findings.
     * </p>
     * 
     * @return The total count of high severity findings.
     */
    public final Long high() {
        return high;
    }

    /**
     * <p>
     * The total count of medium severity findings.
     * </p>
     * 
     * @return The total count of medium severity findings.
     */
    public final Long medium() {
        return medium;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(all());
        hashCode = 31 * hashCode + Objects.hashCode(critical());
        hashCode = 31 * hashCode + Objects.hashCode(high());
        hashCode = 31 * hashCode + Objects.hashCode(medium());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SeverityCounts)) {
            return false;
        }
        SeverityCounts other = (SeverityCounts) obj;
        return Objects.equals(all(), other.all()) && Objects.equals(critical(), other.critical())
                && Objects.equals(high(), other.high()) && Objects.equals(medium(), other.medium());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SeverityCounts").add("All", all()).add("Critical", critical()).add("High", high())
                .add("Medium", medium()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "all":
            return Optional.ofNullable(clazz.cast(all()));
        case "critical":
            return Optional.ofNullable(clazz.cast(critical()));
        case "high":
            return Optional.ofNullable(clazz.cast(high()));
        case "medium":
            return Optional.ofNullable(clazz.cast(medium()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SeverityCounts, T> g) {
        return obj -> g.apply((SeverityCounts) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SeverityCounts> {
        /**
         * <p>
         * The total count of findings from all severities.
         * </p>
         * 
         * @param all
         *        The total count of findings from all severities.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder all(Long all);

        /**
         * <p>
         * The total count of critical severity findings.
         * </p>
         * 
         * @param critical
         *        The total count of critical severity findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder critical(Long critical);

        /**
         * <p>
         * The total count of high severity findings.
         * </p>
         * 
         * @param high
         *        The total count of high severity findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder high(Long high);

        /**
         * <p>
         * The total count of medium severity findings.
         * </p>
         * 
         * @param medium
         *        The total count of medium severity findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder medium(Long medium);
    }

    static final class BuilderImpl implements Builder {
        private Long all;

        private Long critical;

        private Long high;

        private Long medium;

        private BuilderImpl() {
        }

        private BuilderImpl(SeverityCounts model) {
            all(model.all);
            critical(model.critical);
            high(model.high);
            medium(model.medium);
        }

        public final Long getAll() {
            return all;
        }

        public final void setAll(Long all) {
            this.all = all;
        }

        @Override
        public final Builder all(Long all) {
            this.all = all;
            return this;
        }

        public final Long getCritical() {
            return critical;
        }

        public final void setCritical(Long critical) {
            this.critical = critical;
        }

        @Override
        public final Builder critical(Long critical) {
            this.critical = critical;
            return this;
        }

        public final Long getHigh() {
            return high;
        }

        public final void setHigh(Long high) {
            this.high = high;
        }

        @Override
        public final Builder high(Long high) {
            this.high = high;
            return this;
        }

        public final Long getMedium() {
            return medium;
        }

        public final void setMedium(Long medium) {
            this.medium = medium;
        }

        @Override
        public final Builder medium(Long medium) {
            this.medium = medium;
            return this;
        }

        @Override
        public SeverityCounts build() {
            return new SeverityCounts(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
