/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListFindingsRequest extends Inspector2Request implements
        ToCopyableBuilder<ListFindingsRequest.Builder, ListFindingsRequest> {
    private static final SdkField<FilterCriteria> FILTER_CRITERIA_FIELD = SdkField
            .<FilterCriteria> builder(MarshallingType.SDK_POJO).memberName("filterCriteria")
            .getter(getter(ListFindingsRequest::filterCriteria)).setter(setter(Builder::filterCriteria))
            .constructor(FilterCriteria::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterCriteria").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListFindingsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListFindingsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<SortCriteria> SORT_CRITERIA_FIELD = SdkField.<SortCriteria> builder(MarshallingType.SDK_POJO)
            .memberName("sortCriteria").getter(getter(ListFindingsRequest::sortCriteria)).setter(setter(Builder::sortCriteria))
            .constructor(SortCriteria::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortCriteria").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_CRITERIA_FIELD,
            MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, SORT_CRITERIA_FIELD));

    private final FilterCriteria filterCriteria;

    private final Integer maxResults;

    private final String nextToken;

    private final SortCriteria sortCriteria;

    private ListFindingsRequest(BuilderImpl builder) {
        super(builder);
        this.filterCriteria = builder.filterCriteria;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.sortCriteria = builder.sortCriteria;
    }

    /**
     * <p>
     * Details on the filters to apply to your finding results.
     * </p>
     * 
     * @return Details on the filters to apply to your finding results.
     */
    public final FilterCriteria filterCriteria() {
        return filterCriteria;
    }

    /**
     * <p>
     * The maximum number of results to return in the response.
     * </p>
     * 
     * @return The maximum number of results to return in the response.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * A token to use for paginating results that are returned in the response. Set the value of this parameter to null
     * for the first request to a list action. For subsequent calls, use the <code>NextToken</code> value returned from
     * the previous request to continue listing results after the first page.
     * </p>
     * 
     * @return A token to use for paginating results that are returned in the response. Set the value of this parameter
     *         to null for the first request to a list action. For subsequent calls, use the <code>NextToken</code>
     *         value returned from the previous request to continue listing results after the first page.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Details on the sort criteria to apply to your finding results.
     * </p>
     * 
     * @return Details on the sort criteria to apply to your finding results.
     */
    public final SortCriteria sortCriteria() {
        return sortCriteria;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(filterCriteria());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(sortCriteria());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFindingsRequest)) {
            return false;
        }
        ListFindingsRequest other = (ListFindingsRequest) obj;
        return Objects.equals(filterCriteria(), other.filterCriteria()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(sortCriteria(), other.sortCriteria());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListFindingsRequest").add("FilterCriteria", filterCriteria()).add("MaxResults", maxResults())
                .add("NextToken", nextToken()).add("SortCriteria", sortCriteria()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "filterCriteria":
            return Optional.ofNullable(clazz.cast(filterCriteria()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "sortCriteria":
            return Optional.ofNullable(clazz.cast(sortCriteria()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListFindingsRequest, T> g) {
        return obj -> g.apply((ListFindingsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Inspector2Request.Builder, SdkPojo, CopyableBuilder<Builder, ListFindingsRequest> {
        /**
         * <p>
         * Details on the filters to apply to your finding results.
         * </p>
         * 
         * @param filterCriteria
         *        Details on the filters to apply to your finding results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterCriteria(FilterCriteria filterCriteria);

        /**
         * <p>
         * Details on the filters to apply to your finding results.
         * </p>
         * This is a convenience method that creates an instance of the {@link FilterCriteria.Builder} avoiding the need
         * to create one manually via {@link FilterCriteria#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FilterCriteria.Builder#build()} is called immediately and its
         * result is passed to {@link #filterCriteria(FilterCriteria)}.
         * 
         * @param filterCriteria
         *        a consumer that will call methods on {@link FilterCriteria.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filterCriteria(FilterCriteria)
         */
        default Builder filterCriteria(Consumer<FilterCriteria.Builder> filterCriteria) {
            return filterCriteria(FilterCriteria.builder().applyMutation(filterCriteria).build());
        }

        /**
         * <p>
         * The maximum number of results to return in the response.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * A token to use for paginating results that are returned in the response. Set the value of this parameter to
         * null for the first request to a list action. For subsequent calls, use the <code>NextToken</code> value
         * returned from the previous request to continue listing results after the first page.
         * </p>
         * 
         * @param nextToken
         *        A token to use for paginating results that are returned in the response. Set the value of this
         *        parameter to null for the first request to a list action. For subsequent calls, use the
         *        <code>NextToken</code> value returned from the previous request to continue listing results after the
         *        first page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Details on the sort criteria to apply to your finding results.
         * </p>
         * 
         * @param sortCriteria
         *        Details on the sort criteria to apply to your finding results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sortCriteria(SortCriteria sortCriteria);

        /**
         * <p>
         * Details on the sort criteria to apply to your finding results.
         * </p>
         * This is a convenience method that creates an instance of the {@link SortCriteria.Builder} avoiding the need
         * to create one manually via {@link SortCriteria#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SortCriteria.Builder#build()} is called immediately and its
         * result is passed to {@link #sortCriteria(SortCriteria)}.
         * 
         * @param sortCriteria
         *        a consumer that will call methods on {@link SortCriteria.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sortCriteria(SortCriteria)
         */
        default Builder sortCriteria(Consumer<SortCriteria.Builder> sortCriteria) {
            return sortCriteria(SortCriteria.builder().applyMutation(sortCriteria).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Inspector2Request.BuilderImpl implements Builder {
        private FilterCriteria filterCriteria;

        private Integer maxResults;

        private String nextToken;

        private SortCriteria sortCriteria;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFindingsRequest model) {
            super(model);
            filterCriteria(model.filterCriteria);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            sortCriteria(model.sortCriteria);
        }

        public final FilterCriteria.Builder getFilterCriteria() {
            return filterCriteria != null ? filterCriteria.toBuilder() : null;
        }

        public final void setFilterCriteria(FilterCriteria.BuilderImpl filterCriteria) {
            this.filterCriteria = filterCriteria != null ? filterCriteria.build() : null;
        }

        @Override
        public final Builder filterCriteria(FilterCriteria filterCriteria) {
            this.filterCriteria = filterCriteria;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final SortCriteria.Builder getSortCriteria() {
            return sortCriteria != null ? sortCriteria.toBuilder() : null;
        }

        public final void setSortCriteria(SortCriteria.BuilderImpl sortCriteria) {
            this.sortCriteria = sortCriteria != null ? sortCriteria.build() : null;
        }

        @Override
        public final Builder sortCriteria(SortCriteria sortCriteria) {
            this.sortCriteria = sortCriteria;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListFindingsRequest build() {
            return new ListFindingsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
