/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the Amazon Inspector free trial for an account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FreeTrialAccountInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<FreeTrialAccountInfo.Builder, FreeTrialAccountInfo> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accountId").getter(getter(FreeTrialAccountInfo::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()).build();

    private static final SdkField<List<FreeTrialInfo>> FREE_TRIAL_INFO_FIELD = SdkField
            .<List<FreeTrialInfo>> builder(MarshallingType.LIST)
            .memberName("freeTrialInfo")
            .getter(getter(FreeTrialAccountInfo::freeTrialInfo))
            .setter(setter(Builder::freeTrialInfo))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("freeTrialInfo").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FreeTrialInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(FreeTrialInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            FREE_TRIAL_INFO_FIELD));

    private static final long serialVersionUID = 1L;

    private final String accountId;

    private final List<FreeTrialInfo> freeTrialInfo;

    private FreeTrialAccountInfo(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.freeTrialInfo = builder.freeTrialInfo;
    }

    /**
     * <p>
     * The account associated with the Amazon Inspector free trial information.
     * </p>
     * 
     * @return The account associated with the Amazon Inspector free trial information.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * For responses, this returns true if the service returned a value for the FreeTrialInfo property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFreeTrialInfo() {
        return freeTrialInfo != null && !(freeTrialInfo instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains information about the Amazon Inspector free trial for an account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFreeTrialInfo} method.
     * </p>
     * 
     * @return Contains information about the Amazon Inspector free trial for an account.
     */
    public final List<FreeTrialInfo> freeTrialInfo() {
        return freeTrialInfo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(hasFreeTrialInfo() ? freeTrialInfo() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FreeTrialAccountInfo)) {
            return false;
        }
        FreeTrialAccountInfo other = (FreeTrialAccountInfo) obj;
        return Objects.equals(accountId(), other.accountId()) && hasFreeTrialInfo() == other.hasFreeTrialInfo()
                && Objects.equals(freeTrialInfo(), other.freeTrialInfo());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FreeTrialAccountInfo").add("AccountId", accountId())
                .add("FreeTrialInfo", hasFreeTrialInfo() ? freeTrialInfo() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "freeTrialInfo":
            return Optional.ofNullable(clazz.cast(freeTrialInfo()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FreeTrialAccountInfo, T> g) {
        return obj -> g.apply((FreeTrialAccountInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FreeTrialAccountInfo> {
        /**
         * <p>
         * The account associated with the Amazon Inspector free trial information.
         * </p>
         * 
         * @param accountId
         *        The account associated with the Amazon Inspector free trial information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * Contains information about the Amazon Inspector free trial for an account.
         * </p>
         * 
         * @param freeTrialInfo
         *        Contains information about the Amazon Inspector free trial for an account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder freeTrialInfo(Collection<FreeTrialInfo> freeTrialInfo);

        /**
         * <p>
         * Contains information about the Amazon Inspector free trial for an account.
         * </p>
         * 
         * @param freeTrialInfo
         *        Contains information about the Amazon Inspector free trial for an account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder freeTrialInfo(FreeTrialInfo... freeTrialInfo);

        /**
         * <p>
         * Contains information about the Amazon Inspector free trial for an account.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.FreeTrialInfo.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.inspector2.model.FreeTrialInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.FreeTrialInfo.Builder#build()} is called immediately
         * and its result is passed to {@link #freeTrialInfo(List<FreeTrialInfo>)}.
         * 
         * @param freeTrialInfo
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.FreeTrialInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #freeTrialInfo(java.util.Collection<FreeTrialInfo>)
         */
        Builder freeTrialInfo(Consumer<FreeTrialInfo.Builder>... freeTrialInfo);
    }

    static final class BuilderImpl implements Builder {
        private String accountId;

        private List<FreeTrialInfo> freeTrialInfo = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FreeTrialAccountInfo model) {
            accountId(model.accountId);
            freeTrialInfo(model.freeTrialInfo);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final List<FreeTrialInfo.Builder> getFreeTrialInfo() {
            List<FreeTrialInfo.Builder> result = FreeTrialInfoListCopier.copyToBuilder(this.freeTrialInfo);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFreeTrialInfo(Collection<FreeTrialInfo.BuilderImpl> freeTrialInfo) {
            this.freeTrialInfo = FreeTrialInfoListCopier.copyFromBuilder(freeTrialInfo);
        }

        @Override
        public final Builder freeTrialInfo(Collection<FreeTrialInfo> freeTrialInfo) {
            this.freeTrialInfo = FreeTrialInfoListCopier.copy(freeTrialInfo);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder freeTrialInfo(FreeTrialInfo... freeTrialInfo) {
            freeTrialInfo(Arrays.asList(freeTrialInfo));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder freeTrialInfo(Consumer<FreeTrialInfo.Builder>... freeTrialInfo) {
            freeTrialInfo(Stream.of(freeTrialInfo).map(c -> FreeTrialInfo.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public FreeTrialAccountInfo build() {
            return new FreeTrialAccountInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
