/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details of a coverage string filter.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CoverageStringFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<CoverageStringFilter.Builder, CoverageStringFilter> {
    private static final SdkField<String> COMPARISON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("comparison").getter(getter(CoverageStringFilter::comparisonAsString))
            .setter(setter(Builder::comparison))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("comparison").build()).build();

    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("value")
            .getter(getter(CoverageStringFilter::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(COMPARISON_FIELD, VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String comparison;

    private final String value;

    private CoverageStringFilter(BuilderImpl builder) {
        this.comparison = builder.comparison;
        this.value = builder.value;
    }

    /**
     * <p>
     * The operator to compare strings on.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #comparison} will
     * return {@link CoverageStringComparison#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #comparisonAsString}.
     * </p>
     * 
     * @return The operator to compare strings on.
     * @see CoverageStringComparison
     */
    public final CoverageStringComparison comparison() {
        return CoverageStringComparison.fromValue(comparison);
    }

    /**
     * <p>
     * The operator to compare strings on.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #comparison} will
     * return {@link CoverageStringComparison#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #comparisonAsString}.
     * </p>
     * 
     * @return The operator to compare strings on.
     * @see CoverageStringComparison
     */
    public final String comparisonAsString() {
        return comparison;
    }

    /**
     * <p>
     * The value to compare strings on.
     * </p>
     * 
     * @return The value to compare strings on.
     */
    public final String value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(comparisonAsString());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CoverageStringFilter)) {
            return false;
        }
        CoverageStringFilter other = (CoverageStringFilter) obj;
        return Objects.equals(comparisonAsString(), other.comparisonAsString()) && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CoverageStringFilter").add("Comparison", comparisonAsString()).add("Value", value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "comparison":
            return Optional.ofNullable(clazz.cast(comparisonAsString()));
        case "value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CoverageStringFilter, T> g) {
        return obj -> g.apply((CoverageStringFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CoverageStringFilter> {
        /**
         * <p>
         * The operator to compare strings on.
         * </p>
         * 
         * @param comparison
         *        The operator to compare strings on.
         * @see CoverageStringComparison
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CoverageStringComparison
         */
        Builder comparison(String comparison);

        /**
         * <p>
         * The operator to compare strings on.
         * </p>
         * 
         * @param comparison
         *        The operator to compare strings on.
         * @see CoverageStringComparison
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CoverageStringComparison
         */
        Builder comparison(CoverageStringComparison comparison);

        /**
         * <p>
         * The value to compare strings on.
         * </p>
         * 
         * @param value
         *        The value to compare strings on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);
    }

    static final class BuilderImpl implements Builder {
        private String comparison;

        private String value;

        private BuilderImpl() {
        }

        private BuilderImpl(CoverageStringFilter model) {
            comparison(model.comparison);
            value(model.value);
        }

        public final String getComparison() {
            return comparison;
        }

        public final void setComparison(String comparison) {
            this.comparison = comparison;
        }

        @Override
        public final Builder comparison(String comparison) {
            this.comparison = comparison;
            return this;
        }

        @Override
        public final Builder comparison(CoverageStringComparison comparison) {
            this.comparison(comparison == null ? null : comparison.toString());
            return this;
        }

        public final String getValue() {
            return value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        @Override
        public CoverageStringFilter build() {
            return new CoverageStringFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
