/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.inspector2.Inspector2Client;
import software.amazon.awssdk.services.inspector2.model.Filter;
import software.amazon.awssdk.services.inspector2.model.ListFiltersRequest;
import software.amazon.awssdk.services.inspector2.model.ListFiltersResponse;

public class ListFiltersIterable
implements SdkIterable<ListFiltersResponse> {
    private final Inspector2Client client;
    private final ListFiltersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListFiltersIterable(Inspector2Client client, ListFiltersRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListFiltersResponseFetcher();
    }

    public Iterator<ListFiltersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Filter> filters() {
        Function<ListFiltersResponse, Iterator> getIterator = response -> {
            if (response != null && response.filters() != null) {
                return response.filters().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListFiltersResponseFetcher
    implements SyncPageFetcher<ListFiltersResponse> {
        private ListFiltersResponseFetcher() {
        }

        public boolean hasNextPage(ListFiltersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListFiltersResponse nextPage(ListFiltersResponse previousPage) {
            if (previousPage == null) {
                return ListFiltersIterable.this.client.listFilters(ListFiltersIterable.this.firstRequest);
            }
            return ListFiltersIterable.this.client.listFilters((ListFiltersRequest)((Object)ListFiltersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

