/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.inspector2.Inspector2Client;
import software.amazon.awssdk.services.inspector2.model.Counts;
import software.amazon.awssdk.services.inspector2.model.ListCoverageStatisticsRequest;
import software.amazon.awssdk.services.inspector2.model.ListCoverageStatisticsResponse;

public class ListCoverageStatisticsIterable
implements SdkIterable<ListCoverageStatisticsResponse> {
    private final Inspector2Client client;
    private final ListCoverageStatisticsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListCoverageStatisticsIterable(Inspector2Client client, ListCoverageStatisticsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListCoverageStatisticsResponseFetcher();
    }

    public Iterator<ListCoverageStatisticsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Counts> countsByGroup() {
        Function<ListCoverageStatisticsResponse, Iterator> getIterator = response -> {
            if (response != null && response.countsByGroup() != null) {
                return response.countsByGroup().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListCoverageStatisticsResponseFetcher
    implements SyncPageFetcher<ListCoverageStatisticsResponse> {
        private ListCoverageStatisticsResponseFetcher() {
        }

        public boolean hasNextPage(ListCoverageStatisticsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListCoverageStatisticsResponse nextPage(ListCoverageStatisticsResponse previousPage) {
            if (previousPage == null) {
                return ListCoverageStatisticsIterable.this.client.listCoverageStatistics(ListCoverageStatisticsIterable.this.firstRequest);
            }
            return ListCoverageStatisticsIterable.this.client.listCoverageStatistics((ListCoverageStatisticsRequest)((Object)ListCoverageStatisticsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

