/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.inspector2.Inspector2AsyncClient;
import software.amazon.awssdk.services.inspector2.model.ListAccountPermissionsRequest;
import software.amazon.awssdk.services.inspector2.model.ListAccountPermissionsResponse;
import software.amazon.awssdk.services.inspector2.model.Permission;

public class ListAccountPermissionsPublisher
implements SdkPublisher<ListAccountPermissionsResponse> {
    private final Inspector2AsyncClient client;
    private final ListAccountPermissionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAccountPermissionsPublisher(Inspector2AsyncClient client, ListAccountPermissionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAccountPermissionsPublisher(Inspector2AsyncClient client, ListAccountPermissionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAccountPermissionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAccountPermissionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Permission> permissions() {
        Function<ListAccountPermissionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.permissions() != null) {
                return response.permissions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAccountPermissionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAccountPermissionsResponseFetcher
    implements AsyncPageFetcher<ListAccountPermissionsResponse> {
        private ListAccountPermissionsResponseFetcher() {
        }

        public boolean hasNextPage(ListAccountPermissionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAccountPermissionsResponse> nextPage(ListAccountPermissionsResponse previousPage) {
            if (previousPage == null) {
                return ListAccountPermissionsPublisher.this.client.listAccountPermissions(ListAccountPermissionsPublisher.this.firstRequest);
            }
            return ListAccountPermissionsPublisher.this.client.listAccountPermissions((ListAccountPermissionsRequest)((Object)ListAccountPermissionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

