/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum StringComparison {
    EQUALS("EQUALS"),
    PREFIX("PREFIX"),
    NOT_EQUALS("NOT_EQUALS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, StringComparison> VALUE_MAP;
    private final String value;

    private StringComparison(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static StringComparison fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<StringComparison> knownValues() {
        EnumSet<StringComparison> knownValues = EnumSet.allOf(StringComparison.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(StringComparison.class, StringComparison::toString);
    }
}

