/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAssessmentRunAgentsResponse extends InspectorResponse implements
        ToCopyableBuilder<ListAssessmentRunAgentsResponse.Builder, ListAssessmentRunAgentsResponse> {
    private static final SdkField<List<AssessmentRunAgent>> ASSESSMENT_RUN_AGENTS_FIELD = SdkField
            .<List<AssessmentRunAgent>> builder(MarshallingType.LIST)
            .memberName("assessmentRunAgents")
            .getter(getter(ListAssessmentRunAgentsResponse::assessmentRunAgents))
            .setter(setter(Builder::assessmentRunAgents))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentRunAgents").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AssessmentRunAgent> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssessmentRunAgent::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListAssessmentRunAgentsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSESSMENT_RUN_AGENTS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<AssessmentRunAgent> assessmentRunAgents;

    private final String nextToken;

    private ListAssessmentRunAgentsResponse(BuilderImpl builder) {
        super(builder);
        this.assessmentRunAgents = builder.assessmentRunAgents;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the AssessmentRunAgents property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAssessmentRunAgents() {
        return assessmentRunAgents != null && !(assessmentRunAgents instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of ARNs that specifies the agents returned by the action.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssessmentRunAgents} method.
     * </p>
     * 
     * @return A list of ARNs that specifies the agents returned by the action.
     */
    public final List<AssessmentRunAgent> assessmentRunAgents() {
        return assessmentRunAgents;
    }

    /**
     * <p>
     * When a response is generated, if there is more data to be listed, this parameter is present in the response and
     * contains the value to use for the <b>nextToken</b> parameter in a subsequent pagination request. If there is no
     * more data to be listed, this parameter is set to null.
     * </p>
     * 
     * @return When a response is generated, if there is more data to be listed, this parameter is present in the
     *         response and contains the value to use for the <b>nextToken</b> parameter in a subsequent pagination
     *         request. If there is no more data to be listed, this parameter is set to null.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAssessmentRunAgents() ? assessmentRunAgents() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAssessmentRunAgentsResponse)) {
            return false;
        }
        ListAssessmentRunAgentsResponse other = (ListAssessmentRunAgentsResponse) obj;
        return hasAssessmentRunAgents() == other.hasAssessmentRunAgents()
                && Objects.equals(assessmentRunAgents(), other.assessmentRunAgents())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAssessmentRunAgentsResponse")
                .add("AssessmentRunAgents", hasAssessmentRunAgents() ? assessmentRunAgents() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assessmentRunAgents":
            return Optional.ofNullable(clazz.cast(assessmentRunAgents()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAssessmentRunAgentsResponse, T> g) {
        return obj -> g.apply((ListAssessmentRunAgentsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends InspectorResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListAssessmentRunAgentsResponse> {
        /**
         * <p>
         * A list of ARNs that specifies the agents returned by the action.
         * </p>
         * 
         * @param assessmentRunAgents
         *        A list of ARNs that specifies the agents returned by the action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assessmentRunAgents(Collection<AssessmentRunAgent> assessmentRunAgents);

        /**
         * <p>
         * A list of ARNs that specifies the agents returned by the action.
         * </p>
         * 
         * @param assessmentRunAgents
         *        A list of ARNs that specifies the agents returned by the action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assessmentRunAgents(AssessmentRunAgent... assessmentRunAgents);

        /**
         * <p>
         * A list of ARNs that specifies the agents returned by the action.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector.model.AssessmentRunAgent.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.inspector.model.AssessmentRunAgent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector.model.AssessmentRunAgent.Builder#build()} is called
         * immediately and its result is passed to {@link #assessmentRunAgents(List<AssessmentRunAgent>)}.
         * 
         * @param assessmentRunAgents
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector.model.AssessmentRunAgent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #assessmentRunAgents(java.util.Collection<AssessmentRunAgent>)
         */
        Builder assessmentRunAgents(Consumer<AssessmentRunAgent.Builder>... assessmentRunAgents);

        /**
         * <p>
         * When a response is generated, if there is more data to be listed, this parameter is present in the response
         * and contains the value to use for the <b>nextToken</b> parameter in a subsequent pagination request. If there
         * is no more data to be listed, this parameter is set to null.
         * </p>
         * 
         * @param nextToken
         *        When a response is generated, if there is more data to be listed, this parameter is present in the
         *        response and contains the value to use for the <b>nextToken</b> parameter in a subsequent pagination
         *        request. If there is no more data to be listed, this parameter is set to null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends InspectorResponse.BuilderImpl implements Builder {
        private List<AssessmentRunAgent> assessmentRunAgents = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAssessmentRunAgentsResponse model) {
            super(model);
            assessmentRunAgents(model.assessmentRunAgents);
            nextToken(model.nextToken);
        }

        public final List<AssessmentRunAgent.Builder> getAssessmentRunAgents() {
            List<AssessmentRunAgent.Builder> result = AssessmentRunAgentListCopier.copyToBuilder(this.assessmentRunAgents);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssessmentRunAgents(Collection<AssessmentRunAgent.BuilderImpl> assessmentRunAgents) {
            this.assessmentRunAgents = AssessmentRunAgentListCopier.copyFromBuilder(assessmentRunAgents);
        }

        @Override
        public final Builder assessmentRunAgents(Collection<AssessmentRunAgent> assessmentRunAgents) {
            this.assessmentRunAgents = AssessmentRunAgentListCopier.copy(assessmentRunAgents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assessmentRunAgents(AssessmentRunAgent... assessmentRunAgents) {
            assessmentRunAgents(Arrays.asList(assessmentRunAgents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assessmentRunAgents(Consumer<AssessmentRunAgent.Builder>... assessmentRunAgents) {
            assessmentRunAgents(Stream.of(assessmentRunAgents).map(c -> AssessmentRunAgent.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAssessmentRunAgentsResponse build() {
            return new ListAssessmentRunAgentsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
