/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.healthlake.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListFhirDatastoresRequest extends HealthLakeRequest implements
        ToCopyableBuilder<ListFhirDatastoresRequest.Builder, ListFhirDatastoresRequest> {
    private static final SdkField<DatastoreFilter> FILTER_FIELD = SdkField.<DatastoreFilter> builder(MarshallingType.SDK_POJO)
            .memberName("Filter").getter(getter(ListFhirDatastoresRequest::filter)).setter(setter(Builder::filter))
            .constructor(DatastoreFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListFhirDatastoresRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListFhirDatastoresRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_FIELD,
            NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private final DatastoreFilter filter;

    private final String nextToken;

    private final Integer maxResults;

    private ListFhirDatastoresRequest(BuilderImpl builder) {
        super(builder);
        this.filter = builder.filter;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * Lists all filters associated with a FHIR data store request.
     * </p>
     * 
     * @return Lists all filters associated with a FHIR data store request.
     */
    public final DatastoreFilter filter() {
        return filter;
    }

    /**
     * <p>
     * Fetches the next page of data stores when results are paginated.
     * </p>
     * 
     * @return Fetches the next page of data stores when results are paginated.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of data stores returned in a single page of a ListFHIRDatastoresRequest call.
     * </p>
     * 
     * @return The maximum number of data stores returned in a single page of a ListFHIRDatastoresRequest call.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(filter());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFhirDatastoresRequest)) {
            return false;
        }
        ListFhirDatastoresRequest other = (ListFhirDatastoresRequest) obj;
        return Objects.equals(filter(), other.filter()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListFhirDatastoresRequest").add("Filter", filter()).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Filter":
            return Optional.ofNullable(clazz.cast(filter()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListFhirDatastoresRequest, T> g) {
        return obj -> g.apply((ListFhirDatastoresRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends HealthLakeRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListFhirDatastoresRequest> {
        /**
         * <p>
         * Lists all filters associated with a FHIR data store request.
         * </p>
         * 
         * @param filter
         *        Lists all filters associated with a FHIR data store request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filter(DatastoreFilter filter);

        /**
         * <p>
         * Lists all filters associated with a FHIR data store request.
         * </p>
         * This is a convenience method that creates an instance of the {@link DatastoreFilter.Builder} avoiding the
         * need to create one manually via {@link DatastoreFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DatastoreFilter.Builder#build()} is called immediately and its
         * result is passed to {@link #filter(DatastoreFilter)}.
         * 
         * @param filter
         *        a consumer that will call methods on {@link DatastoreFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filter(DatastoreFilter)
         */
        default Builder filter(Consumer<DatastoreFilter.Builder> filter) {
            return filter(DatastoreFilter.builder().applyMutation(filter).build());
        }

        /**
         * <p>
         * Fetches the next page of data stores when results are paginated.
         * </p>
         * 
         * @param nextToken
         *        Fetches the next page of data stores when results are paginated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of data stores returned in a single page of a ListFHIRDatastoresRequest call.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of data stores returned in a single page of a ListFHIRDatastoresRequest call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends HealthLakeRequest.BuilderImpl implements Builder {
        private DatastoreFilter filter;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFhirDatastoresRequest model) {
            super(model);
            filter(model.filter);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final DatastoreFilter.Builder getFilter() {
            return filter != null ? filter.toBuilder() : null;
        }

        public final void setFilter(DatastoreFilter.BuilderImpl filter) {
            this.filter = filter != null ? filter.build() : null;
        }

        @Override
        public final Builder filter(DatastoreFilter filter) {
            this.filter = filter;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListFhirDatastoresRequest build() {
            return new ListFhirDatastoresRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
