/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.health.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.health.model.EventScopeCode;
import software.amazon.awssdk.services.health.model.EventStatusCode;
import software.amazon.awssdk.services.health.model.EventTypeCategory;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OrganizationEvent
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OrganizationEvent> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(OrganizationEvent.getter(OrganizationEvent::arn)).setter(OrganizationEvent.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> SERVICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("service").getter(OrganizationEvent.getter(OrganizationEvent::service)).setter(OrganizationEvent.setter(Builder::service)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("service").build()}).build();
    private static final SdkField<String> EVENT_TYPE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("eventTypeCode").getter(OrganizationEvent.getter(OrganizationEvent::eventTypeCode)).setter(OrganizationEvent.setter(Builder::eventTypeCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventTypeCode").build()}).build();
    private static final SdkField<String> EVENT_TYPE_CATEGORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("eventTypeCategory").getter(OrganizationEvent.getter(OrganizationEvent::eventTypeCategoryAsString)).setter(OrganizationEvent.setter(Builder::eventTypeCategory)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventTypeCategory").build()}).build();
    private static final SdkField<String> EVENT_SCOPE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("eventScopeCode").getter(OrganizationEvent.getter(OrganizationEvent::eventScopeCodeAsString)).setter(OrganizationEvent.setter(Builder::eventScopeCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventScopeCode").build()}).build();
    private static final SdkField<String> REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("region").getter(OrganizationEvent.getter(OrganizationEvent::region)).setter(OrganizationEvent.setter(Builder::region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("region").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startTime").getter(OrganizationEvent.getter(OrganizationEvent::startTime)).setter(OrganizationEvent.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endTime").getter(OrganizationEvent.getter(OrganizationEvent::endTime)).setter(OrganizationEvent.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedTime").getter(OrganizationEvent.getter(OrganizationEvent::lastUpdatedTime)).setter(OrganizationEvent.setter(Builder::lastUpdatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedTime").build()}).build();
    private static final SdkField<String> STATUS_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusCode").getter(OrganizationEvent.getter(OrganizationEvent::statusCodeAsString)).setter(OrganizationEvent.setter(Builder::statusCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusCode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, SERVICE_FIELD, EVENT_TYPE_CODE_FIELD, EVENT_TYPE_CATEGORY_FIELD, EVENT_SCOPE_CODE_FIELD, REGION_FIELD, START_TIME_FIELD, END_TIME_FIELD, LAST_UPDATED_TIME_FIELD, STATUS_CODE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String service;
    private final String eventTypeCode;
    private final String eventTypeCategory;
    private final String eventScopeCode;
    private final String region;
    private final Instant startTime;
    private final Instant endTime;
    private final Instant lastUpdatedTime;
    private final String statusCodeValue;

    private OrganizationEvent(BuilderImpl builder) {
        this.arn = builder.arn;
        this.service = builder.service;
        this.eventTypeCode = builder.eventTypeCode;
        this.eventTypeCategory = builder.eventTypeCategory;
        this.eventScopeCode = builder.eventScopeCode;
        this.region = builder.region;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.statusCodeValue = builder.statusCodeValue;
    }

    public final String arn() {
        return this.arn;
    }

    public final String service() {
        return this.service;
    }

    public final String eventTypeCode() {
        return this.eventTypeCode;
    }

    public final EventTypeCategory eventTypeCategory() {
        return EventTypeCategory.fromValue(this.eventTypeCategory);
    }

    public final String eventTypeCategoryAsString() {
        return this.eventTypeCategory;
    }

    public final EventScopeCode eventScopeCode() {
        return EventScopeCode.fromValue(this.eventScopeCode);
    }

    public final String eventScopeCodeAsString() {
        return this.eventScopeCode;
    }

    public final String region() {
        return this.region;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final Instant lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public final EventStatusCode statusCode() {
        return EventStatusCode.fromValue(this.statusCodeValue);
    }

    public final String statusCodeAsString() {
        return this.statusCodeValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.service());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventTypeCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventTypeCategoryAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventScopeCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusCodeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OrganizationEvent)) {
            return false;
        }
        OrganizationEvent other = (OrganizationEvent)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.service(), other.service()) && Objects.equals(this.eventTypeCode(), other.eventTypeCode()) && Objects.equals(this.eventTypeCategoryAsString(), other.eventTypeCategoryAsString()) && Objects.equals(this.eventScopeCodeAsString(), other.eventScopeCodeAsString()) && Objects.equals(this.region(), other.region()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.lastUpdatedTime(), other.lastUpdatedTime()) && Objects.equals(this.statusCodeAsString(), other.statusCodeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"OrganizationEvent").add("Arn", (Object)this.arn()).add("Service", (Object)this.service()).add("EventTypeCode", (Object)this.eventTypeCode()).add("EventTypeCategory", (Object)this.eventTypeCategoryAsString()).add("EventScopeCode", (Object)this.eventScopeCodeAsString()).add("Region", (Object)this.region()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("LastUpdatedTime", (Object)this.lastUpdatedTime()).add("StatusCode", (Object)this.statusCodeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "service": {
                return Optional.ofNullable(clazz.cast(this.service()));
            }
            case "eventTypeCode": {
                return Optional.ofNullable(clazz.cast(this.eventTypeCode()));
            }
            case "eventTypeCategory": {
                return Optional.ofNullable(clazz.cast(this.eventTypeCategoryAsString()));
            }
            case "eventScopeCode": {
                return Optional.ofNullable(clazz.cast(this.eventScopeCodeAsString()));
            }
            case "region": {
                return Optional.ofNullable(clazz.cast(this.region()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "endTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "lastUpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTime()));
            }
            case "statusCode": {
                return Optional.ofNullable(clazz.cast(this.statusCodeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OrganizationEvent, T> g) {
        return obj -> g.apply((OrganizationEvent)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String service;
        private String eventTypeCode;
        private String eventTypeCategory;
        private String eventScopeCode;
        private String region;
        private Instant startTime;
        private Instant endTime;
        private Instant lastUpdatedTime;
        private String statusCodeValue;

        private BuilderImpl() {
        }

        private BuilderImpl(OrganizationEvent model) {
            this.arn(model.arn);
            this.service(model.service);
            this.eventTypeCode(model.eventTypeCode);
            this.eventTypeCategory(model.eventTypeCategory);
            this.eventScopeCode(model.eventScopeCode);
            this.region(model.region);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.lastUpdatedTime(model.lastUpdatedTime);
            this.statusCode(model.statusCodeValue);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getService() {
            return this.service;
        }

        public final void setService(String service) {
            this.service = service;
        }

        @Override
        public final Builder service(String service) {
            this.service = service;
            return this;
        }

        public final String getEventTypeCode() {
            return this.eventTypeCode;
        }

        public final void setEventTypeCode(String eventTypeCode) {
            this.eventTypeCode = eventTypeCode;
        }

        @Override
        public final Builder eventTypeCode(String eventTypeCode) {
            this.eventTypeCode = eventTypeCode;
            return this;
        }

        public final String getEventTypeCategory() {
            return this.eventTypeCategory;
        }

        public final void setEventTypeCategory(String eventTypeCategory) {
            this.eventTypeCategory = eventTypeCategory;
        }

        @Override
        public final Builder eventTypeCategory(String eventTypeCategory) {
            this.eventTypeCategory = eventTypeCategory;
            return this;
        }

        @Override
        public final Builder eventTypeCategory(EventTypeCategory eventTypeCategory) {
            this.eventTypeCategory(eventTypeCategory == null ? null : eventTypeCategory.toString());
            return this;
        }

        public final String getEventScopeCode() {
            return this.eventScopeCode;
        }

        public final void setEventScopeCode(String eventScopeCode) {
            this.eventScopeCode = eventScopeCode;
        }

        @Override
        public final Builder eventScopeCode(String eventScopeCode) {
            this.eventScopeCode = eventScopeCode;
            return this;
        }

        @Override
        public final Builder eventScopeCode(EventScopeCode eventScopeCode) {
            this.eventScopeCode(eventScopeCode == null ? null : eventScopeCode.toString());
            return this;
        }

        public final String getRegion() {
            return this.region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final String getStatusCode() {
            return this.statusCodeValue;
        }

        public final void setStatusCode(String statusCodeValue) {
            this.statusCodeValue = statusCodeValue;
        }

        @Override
        public final Builder statusCode(String statusCodeValue) {
            this.statusCodeValue = statusCodeValue;
            return this;
        }

        @Override
        public final Builder statusCode(EventStatusCode statusCodeValue) {
            this.statusCode(statusCodeValue == null ? null : statusCodeValue.toString());
            return this;
        }

        public OrganizationEvent build() {
            return new OrganizationEvent(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OrganizationEvent> {
        public Builder arn(String var1);

        public Builder service(String var1);

        public Builder eventTypeCode(String var1);

        public Builder eventTypeCategory(String var1);

        public Builder eventTypeCategory(EventTypeCategory var1);

        public Builder eventScopeCode(String var1);

        public Builder eventScopeCode(EventScopeCode var1);

        public Builder region(String var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder lastUpdatedTime(Instant var1);

        public Builder statusCode(String var1);

        public Builder statusCode(EventStatusCode var1);
    }
}

