/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.health.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum EventTypeCategory {
    ISSUE("issue"),
    ACCOUNT_NOTIFICATION("accountNotification"),
    SCHEDULED_CHANGE("scheduledChange"),
    INVESTIGATION("investigation"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, EventTypeCategory> VALUE_MAP;
    private final String value;

    private EventTypeCategory(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EventTypeCategory fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EventTypeCategory> knownValues() {
        EnumSet<EventTypeCategory> knownValues = EnumSet.allOf(EventTypeCategory.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(EventTypeCategory.class, EventTypeCategory::toString);
    }
}

