/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.guardduty.GuardDutyClient;
import software.amazon.awssdk.services.guardduty.internal.UserAgentUtils;
import software.amazon.awssdk.services.guardduty.model.AdminAccount;
import software.amazon.awssdk.services.guardduty.model.ListOrganizationAdminAccountsRequest;
import software.amazon.awssdk.services.guardduty.model.ListOrganizationAdminAccountsResponse;

public class ListOrganizationAdminAccountsIterable
implements SdkIterable<ListOrganizationAdminAccountsResponse> {
    private final GuardDutyClient client;
    private final ListOrganizationAdminAccountsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListOrganizationAdminAccountsIterable(GuardDutyClient client, ListOrganizationAdminAccountsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListOrganizationAdminAccountsResponseFetcher();
    }

    public Iterator<ListOrganizationAdminAccountsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AdminAccount> adminAccounts() {
        Function<ListOrganizationAdminAccountsResponse, Iterator> getIterator = response -> {
            if (response != null && response.adminAccounts() != null) {
                return response.adminAccounts().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListOrganizationAdminAccountsResponseFetcher
    implements SyncPageFetcher<ListOrganizationAdminAccountsResponse> {
        private ListOrganizationAdminAccountsResponseFetcher() {
        }

        public boolean hasNextPage(ListOrganizationAdminAccountsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListOrganizationAdminAccountsResponse nextPage(ListOrganizationAdminAccountsResponse previousPage) {
            if (previousPage == null) {
                return ListOrganizationAdminAccountsIterable.this.client.listOrganizationAdminAccounts(ListOrganizationAdminAccountsIterable.this.firstRequest);
            }
            return ListOrganizationAdminAccountsIterable.this.client.listOrganizationAdminAccounts((ListOrganizationAdminAccountsRequest)((Object)ListOrganizationAdminAccountsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

