/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.guardduty.model.ResourceDetails;
import software.amazon.awssdk.services.guardduty.model.ScanResultDetails;
import software.amazon.awssdk.services.guardduty.model.ScanStatus;
import software.amazon.awssdk.services.guardduty.model.ScanType;
import software.amazon.awssdk.services.guardduty.model.TriggerDetails;
import software.amazon.awssdk.services.guardduty.model.VolumeDetail;
import software.amazon.awssdk.services.guardduty.model.VolumeDetailsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Scan
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Scan> {
    private static final SdkField<String> DETECTOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DetectorId").getter(Scan.getter(Scan::detectorId)).setter(Scan.setter(Builder::detectorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorId").build()}).build();
    private static final SdkField<String> ADMIN_DETECTOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AdminDetectorId").getter(Scan.getter(Scan::adminDetectorId)).setter(Scan.setter(Builder::adminDetectorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("adminDetectorId").build()}).build();
    private static final SdkField<String> SCAN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScanId").getter(Scan.getter(Scan::scanId)).setter(Scan.setter(Builder::scanId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanId").build()}).build();
    private static final SdkField<String> SCAN_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScanStatus").getter(Scan.getter(Scan::scanStatusAsString)).setter(Scan.setter(Builder::scanStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanStatus").build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureReason").getter(Scan.getter(Scan::failureReason)).setter(Scan.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReason").build()}).build();
    private static final SdkField<Instant> SCAN_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ScanStartTime").getter(Scan.getter(Scan::scanStartTime)).setter(Scan.setter(Builder::scanStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanStartTime").build()}).build();
    private static final SdkField<Instant> SCAN_END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ScanEndTime").getter(Scan.getter(Scan::scanEndTime)).setter(Scan.setter(Builder::scanEndTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanEndTime").build()}).build();
    private static final SdkField<TriggerDetails> TRIGGER_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TriggerDetails").getter(Scan.getter(Scan::triggerDetails)).setter(Scan.setter(Builder::triggerDetails)).constructor(TriggerDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("triggerDetails").build()}).build();
    private static final SdkField<ResourceDetails> RESOURCE_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ResourceDetails").getter(Scan.getter(Scan::resourceDetails)).setter(Scan.setter(Builder::resourceDetails)).constructor(ResourceDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceDetails").build()}).build();
    private static final SdkField<ScanResultDetails> SCAN_RESULT_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ScanResultDetails").getter(Scan.getter(Scan::scanResultDetails)).setter(Scan.setter(Builder::scanResultDetails)).constructor(ScanResultDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanResultDetails").build()}).build();
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(Scan.getter(Scan::accountId)).setter(Scan.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()}).build();
    private static final SdkField<Long> TOTAL_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("TotalBytes").getter(Scan.getter(Scan::totalBytes)).setter(Scan.setter(Builder::totalBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalBytes").build()}).build();
    private static final SdkField<Long> FILE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("FileCount").getter(Scan.getter(Scan::fileCount)).setter(Scan.setter(Builder::fileCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileCount").build()}).build();
    private static final SdkField<List<VolumeDetail>> ATTACHED_VOLUMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AttachedVolumes").getter(Scan.getter(Scan::attachedVolumes)).setter(Scan.setter(Builder::attachedVolumes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attachedVolumes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VolumeDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SCAN_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScanType").getter(Scan.getter(Scan::scanTypeAsString)).setter(Scan.setter(Builder::scanType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETECTOR_ID_FIELD, ADMIN_DETECTOR_ID_FIELD, SCAN_ID_FIELD, SCAN_STATUS_FIELD, FAILURE_REASON_FIELD, SCAN_START_TIME_FIELD, SCAN_END_TIME_FIELD, TRIGGER_DETAILS_FIELD, RESOURCE_DETAILS_FIELD, SCAN_RESULT_DETAILS_FIELD, ACCOUNT_ID_FIELD, TOTAL_BYTES_FIELD, FILE_COUNT_FIELD, ATTACHED_VOLUMES_FIELD, SCAN_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String detectorId;
    private final String adminDetectorId;
    private final String scanId;
    private final String scanStatus;
    private final String failureReason;
    private final Instant scanStartTime;
    private final Instant scanEndTime;
    private final TriggerDetails triggerDetails;
    private final ResourceDetails resourceDetails;
    private final ScanResultDetails scanResultDetails;
    private final String accountId;
    private final Long totalBytes;
    private final Long fileCount;
    private final List<VolumeDetail> attachedVolumes;
    private final String scanType;

    private Scan(BuilderImpl builder) {
        this.detectorId = builder.detectorId;
        this.adminDetectorId = builder.adminDetectorId;
        this.scanId = builder.scanId;
        this.scanStatus = builder.scanStatus;
        this.failureReason = builder.failureReason;
        this.scanStartTime = builder.scanStartTime;
        this.scanEndTime = builder.scanEndTime;
        this.triggerDetails = builder.triggerDetails;
        this.resourceDetails = builder.resourceDetails;
        this.scanResultDetails = builder.scanResultDetails;
        this.accountId = builder.accountId;
        this.totalBytes = builder.totalBytes;
        this.fileCount = builder.fileCount;
        this.attachedVolumes = builder.attachedVolumes;
        this.scanType = builder.scanType;
    }

    public final String detectorId() {
        return this.detectorId;
    }

    public final String adminDetectorId() {
        return this.adminDetectorId;
    }

    public final String scanId() {
        return this.scanId;
    }

    public final ScanStatus scanStatus() {
        return ScanStatus.fromValue(this.scanStatus);
    }

    public final String scanStatusAsString() {
        return this.scanStatus;
    }

    public final String failureReason() {
        return this.failureReason;
    }

    public final Instant scanStartTime() {
        return this.scanStartTime;
    }

    public final Instant scanEndTime() {
        return this.scanEndTime;
    }

    public final TriggerDetails triggerDetails() {
        return this.triggerDetails;
    }

    public final ResourceDetails resourceDetails() {
        return this.resourceDetails;
    }

    public final ScanResultDetails scanResultDetails() {
        return this.scanResultDetails;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final Long totalBytes() {
        return this.totalBytes;
    }

    public final Long fileCount() {
        return this.fileCount;
    }

    public final boolean hasAttachedVolumes() {
        return this.attachedVolumes != null && !(this.attachedVolumes instanceof SdkAutoConstructList);
    }

    public final List<VolumeDetail> attachedVolumes() {
        return this.attachedVolumes;
    }

    public final ScanType scanType() {
        return ScanType.fromValue(this.scanType);
    }

    public final String scanTypeAsString() {
        return this.scanType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.detectorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.adminDetectorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.scanId());
        hashCode = 31 * hashCode + Objects.hashCode(this.scanStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.scanStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.scanEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.triggerDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.scanResultDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttachedVolumes() ? this.attachedVolumes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.scanTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Scan)) {
            return false;
        }
        Scan other = (Scan)obj;
        return Objects.equals(this.detectorId(), other.detectorId()) && Objects.equals(this.adminDetectorId(), other.adminDetectorId()) && Objects.equals(this.scanId(), other.scanId()) && Objects.equals(this.scanStatusAsString(), other.scanStatusAsString()) && Objects.equals(this.failureReason(), other.failureReason()) && Objects.equals(this.scanStartTime(), other.scanStartTime()) && Objects.equals(this.scanEndTime(), other.scanEndTime()) && Objects.equals(this.triggerDetails(), other.triggerDetails()) && Objects.equals(this.resourceDetails(), other.resourceDetails()) && Objects.equals(this.scanResultDetails(), other.scanResultDetails()) && Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.totalBytes(), other.totalBytes()) && Objects.equals(this.fileCount(), other.fileCount()) && this.hasAttachedVolumes() == other.hasAttachedVolumes() && Objects.equals(this.attachedVolumes(), other.attachedVolumes()) && Objects.equals(this.scanTypeAsString(), other.scanTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"Scan").add("DetectorId", (Object)this.detectorId()).add("AdminDetectorId", (Object)this.adminDetectorId()).add("ScanId", (Object)this.scanId()).add("ScanStatus", (Object)this.scanStatusAsString()).add("FailureReason", (Object)this.failureReason()).add("ScanStartTime", (Object)this.scanStartTime()).add("ScanEndTime", (Object)this.scanEndTime()).add("TriggerDetails", (Object)this.triggerDetails()).add("ResourceDetails", (Object)this.resourceDetails()).add("ScanResultDetails", (Object)this.scanResultDetails()).add("AccountId", (Object)this.accountId()).add("TotalBytes", (Object)this.totalBytes()).add("FileCount", (Object)this.fileCount()).add("AttachedVolumes", this.hasAttachedVolumes() ? this.attachedVolumes() : null).add("ScanType", (Object)this.scanTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DetectorId": {
                return Optional.ofNullable(clazz.cast(this.detectorId()));
            }
            case "AdminDetectorId": {
                return Optional.ofNullable(clazz.cast(this.adminDetectorId()));
            }
            case "ScanId": {
                return Optional.ofNullable(clazz.cast(this.scanId()));
            }
            case "ScanStatus": {
                return Optional.ofNullable(clazz.cast(this.scanStatusAsString()));
            }
            case "FailureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
            case "ScanStartTime": {
                return Optional.ofNullable(clazz.cast(this.scanStartTime()));
            }
            case "ScanEndTime": {
                return Optional.ofNullable(clazz.cast(this.scanEndTime()));
            }
            case "TriggerDetails": {
                return Optional.ofNullable(clazz.cast(this.triggerDetails()));
            }
            case "ResourceDetails": {
                return Optional.ofNullable(clazz.cast(this.resourceDetails()));
            }
            case "ScanResultDetails": {
                return Optional.ofNullable(clazz.cast(this.scanResultDetails()));
            }
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "TotalBytes": {
                return Optional.ofNullable(clazz.cast(this.totalBytes()));
            }
            case "FileCount": {
                return Optional.ofNullable(clazz.cast(this.fileCount()));
            }
            case "AttachedVolumes": {
                return Optional.ofNullable(clazz.cast(this.attachedVolumes()));
            }
            case "ScanType": {
                return Optional.ofNullable(clazz.cast(this.scanTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Scan, T> g) {
        return obj -> g.apply((Scan)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String detectorId;
        private String adminDetectorId;
        private String scanId;
        private String scanStatus;
        private String failureReason;
        private Instant scanStartTime;
        private Instant scanEndTime;
        private TriggerDetails triggerDetails;
        private ResourceDetails resourceDetails;
        private ScanResultDetails scanResultDetails;
        private String accountId;
        private Long totalBytes;
        private Long fileCount;
        private List<VolumeDetail> attachedVolumes = DefaultSdkAutoConstructList.getInstance();
        private String scanType;

        private BuilderImpl() {
        }

        private BuilderImpl(Scan model) {
            this.detectorId(model.detectorId);
            this.adminDetectorId(model.adminDetectorId);
            this.scanId(model.scanId);
            this.scanStatus(model.scanStatus);
            this.failureReason(model.failureReason);
            this.scanStartTime(model.scanStartTime);
            this.scanEndTime(model.scanEndTime);
            this.triggerDetails(model.triggerDetails);
            this.resourceDetails(model.resourceDetails);
            this.scanResultDetails(model.scanResultDetails);
            this.accountId(model.accountId);
            this.totalBytes(model.totalBytes);
            this.fileCount(model.fileCount);
            this.attachedVolumes(model.attachedVolumes);
            this.scanType(model.scanType);
        }

        public final String getDetectorId() {
            return this.detectorId;
        }

        public final void setDetectorId(String detectorId) {
            this.detectorId = detectorId;
        }

        @Override
        public final Builder detectorId(String detectorId) {
            this.detectorId = detectorId;
            return this;
        }

        public final String getAdminDetectorId() {
            return this.adminDetectorId;
        }

        public final void setAdminDetectorId(String adminDetectorId) {
            this.adminDetectorId = adminDetectorId;
        }

        @Override
        public final Builder adminDetectorId(String adminDetectorId) {
            this.adminDetectorId = adminDetectorId;
            return this;
        }

        public final String getScanId() {
            return this.scanId;
        }

        public final void setScanId(String scanId) {
            this.scanId = scanId;
        }

        @Override
        public final Builder scanId(String scanId) {
            this.scanId = scanId;
            return this;
        }

        public final String getScanStatus() {
            return this.scanStatus;
        }

        public final void setScanStatus(String scanStatus) {
            this.scanStatus = scanStatus;
        }

        @Override
        public final Builder scanStatus(String scanStatus) {
            this.scanStatus = scanStatus;
            return this;
        }

        @Override
        public final Builder scanStatus(ScanStatus scanStatus) {
            this.scanStatus(scanStatus == null ? null : scanStatus.toString());
            return this;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final Instant getScanStartTime() {
            return this.scanStartTime;
        }

        public final void setScanStartTime(Instant scanStartTime) {
            this.scanStartTime = scanStartTime;
        }

        @Override
        public final Builder scanStartTime(Instant scanStartTime) {
            this.scanStartTime = scanStartTime;
            return this;
        }

        public final Instant getScanEndTime() {
            return this.scanEndTime;
        }

        public final void setScanEndTime(Instant scanEndTime) {
            this.scanEndTime = scanEndTime;
        }

        @Override
        public final Builder scanEndTime(Instant scanEndTime) {
            this.scanEndTime = scanEndTime;
            return this;
        }

        public final TriggerDetails.Builder getTriggerDetails() {
            return this.triggerDetails != null ? this.triggerDetails.toBuilder() : null;
        }

        public final void setTriggerDetails(TriggerDetails.BuilderImpl triggerDetails) {
            this.triggerDetails = triggerDetails != null ? triggerDetails.build() : null;
        }

        @Override
        public final Builder triggerDetails(TriggerDetails triggerDetails) {
            this.triggerDetails = triggerDetails;
            return this;
        }

        public final ResourceDetails.Builder getResourceDetails() {
            return this.resourceDetails != null ? this.resourceDetails.toBuilder() : null;
        }

        public final void setResourceDetails(ResourceDetails.BuilderImpl resourceDetails) {
            this.resourceDetails = resourceDetails != null ? resourceDetails.build() : null;
        }

        @Override
        public final Builder resourceDetails(ResourceDetails resourceDetails) {
            this.resourceDetails = resourceDetails;
            return this;
        }

        public final ScanResultDetails.Builder getScanResultDetails() {
            return this.scanResultDetails != null ? this.scanResultDetails.toBuilder() : null;
        }

        public final void setScanResultDetails(ScanResultDetails.BuilderImpl scanResultDetails) {
            this.scanResultDetails = scanResultDetails != null ? scanResultDetails.build() : null;
        }

        @Override
        public final Builder scanResultDetails(ScanResultDetails scanResultDetails) {
            this.scanResultDetails = scanResultDetails;
            return this;
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final Long getTotalBytes() {
            return this.totalBytes;
        }

        public final void setTotalBytes(Long totalBytes) {
            this.totalBytes = totalBytes;
        }

        @Override
        public final Builder totalBytes(Long totalBytes) {
            this.totalBytes = totalBytes;
            return this;
        }

        public final Long getFileCount() {
            return this.fileCount;
        }

        public final void setFileCount(Long fileCount) {
            this.fileCount = fileCount;
        }

        @Override
        public final Builder fileCount(Long fileCount) {
            this.fileCount = fileCount;
            return this;
        }

        public final List<VolumeDetail.Builder> getAttachedVolumes() {
            List<VolumeDetail.Builder> result = VolumeDetailsCopier.copyToBuilder(this.attachedVolumes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttachedVolumes(Collection<VolumeDetail.BuilderImpl> attachedVolumes) {
            this.attachedVolumes = VolumeDetailsCopier.copyFromBuilder(attachedVolumes);
        }

        @Override
        public final Builder attachedVolumes(Collection<VolumeDetail> attachedVolumes) {
            this.attachedVolumes = VolumeDetailsCopier.copy(attachedVolumes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachedVolumes(VolumeDetail ... attachedVolumes) {
            this.attachedVolumes(Arrays.asList(attachedVolumes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachedVolumes(Consumer<VolumeDetail.Builder> ... attachedVolumes) {
            this.attachedVolumes(Stream.of(attachedVolumes).map(c -> (VolumeDetail)((VolumeDetail.Builder)VolumeDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getScanType() {
            return this.scanType;
        }

        public final void setScanType(String scanType) {
            this.scanType = scanType;
        }

        @Override
        public final Builder scanType(String scanType) {
            this.scanType = scanType;
            return this;
        }

        @Override
        public final Builder scanType(ScanType scanType) {
            this.scanType(scanType == null ? null : scanType.toString());
            return this;
        }

        public Scan build() {
            return new Scan(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Scan> {
        public Builder detectorId(String var1);

        public Builder adminDetectorId(String var1);

        public Builder scanId(String var1);

        public Builder scanStatus(String var1);

        public Builder scanStatus(ScanStatus var1);

        public Builder failureReason(String var1);

        public Builder scanStartTime(Instant var1);

        public Builder scanEndTime(Instant var1);

        public Builder triggerDetails(TriggerDetails var1);

        default public Builder triggerDetails(Consumer<TriggerDetails.Builder> triggerDetails) {
            return this.triggerDetails((TriggerDetails)((TriggerDetails.Builder)TriggerDetails.builder().applyMutation(triggerDetails)).build());
        }

        public Builder resourceDetails(ResourceDetails var1);

        default public Builder resourceDetails(Consumer<ResourceDetails.Builder> resourceDetails) {
            return this.resourceDetails((ResourceDetails)((ResourceDetails.Builder)ResourceDetails.builder().applyMutation(resourceDetails)).build());
        }

        public Builder scanResultDetails(ScanResultDetails var1);

        default public Builder scanResultDetails(Consumer<ScanResultDetails.Builder> scanResultDetails) {
            return this.scanResultDetails((ScanResultDetails)((ScanResultDetails.Builder)ScanResultDetails.builder().applyMutation(scanResultDetails)).build());
        }

        public Builder accountId(String var1);

        public Builder totalBytes(Long var1);

        public Builder fileCount(Long var1);

        public Builder attachedVolumes(Collection<VolumeDetail> var1);

        public Builder attachedVolumes(VolumeDetail ... var1);

        public Builder attachedVolumes(Consumer<VolumeDetail.Builder> ... var1);

        public Builder scanType(String var1);

        public Builder scanType(ScanType var1);
    }
}

